% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cache.R
\name{cache_dataset}
\alias{cache_dataset}
\alias{use_cache}
\alias{cache_path}
\alias{cache_info}
\alias{cache_reset}
\title{Utilities for cache management}
\usage{
cache_dataset(version)

cache_path()

cache_info()

cache_reset()
}
\arguments{
\item{version}{A character specifying a version of the dataset.
This can be of the form \code{"1.1"} or \code{"1"} (where in \code{"x.y"}, x is a major
version and y is an optional minor version). As of v0.3.14, setting a version
in this way will cache the dataset (See example in \code{\link{cache_dataset}})
so that it will not re-download the file the second time and read from the cache.
Finally, set \code{use_cache = "none"} to not read from the cache and re-download
afresh even when \code{version} is provided.
If the user specifies a \code{key} or \code{DATAVERSE_KEY} argument, they can access the
draft version by \code{":draft"} (the current draft) or \code{":latest"} (which will
prioritize the draft over the latest published version).}
}
\value{
\code{cache_dataset()} returns \code{"disk"} if the dataset version is to be cached to disk, \code{"none"} otherwise.

\code{cache_path()} returns the file path to the directory containing the cache.

\code{cache_info()} returns a data.frame containing names and sizes of files in the cache.

\code{cache_reset()} returns the path to the (now empty) cache, invisibly)
}
\description{
The dataverse package uses disk and session caches to improve network performance. Use of the cache is described on this page.
}
\details{
Use of the cache is determined by the value of the \verb{use_cache =} argument to dataset and other API calls, or by the environment variable \code{DATAVERSE_USE_CACHE}. Possible values are
\itemize{
\item \code{"none"}: do not use the cache. This is the default for datasets that are versioned with \code{":draft"}, \code{":latest"}, and \code{":latest-published"}.
\item \code{"session"}: cache API requests for the duration of the \emph{R} session. This is the default for API calls that do not involve file or dataset retrieval.
\item `"disk": use a permanent disk cache. This is the default for files and explicitly versioned datasets.
}

\code{cache_dataset()} determines whether a dataset or file should be cached based on the version specification.

\code{cache_path()} finds or creates the location (directory) on the file system containing the cache.

\code{cache_info()} queries the cache for information about the name, size, and other attributes of files in the cache. The file name is a 'hash' of the function used to retrieve the file; it is not useful for identifying specific files.

\code{cache_reset()} clears all downloaded files from the disk cache.
}
\examples{
cache_dataset(":latest")  # "none"
cache_dataset("1.2")      # "disk"

\dontrun{
 # specifying the version will by default store a cache. Add `use_cache = "none"` to turn off
 df_tab <-
  get_dataframe_by_name(
   filename = "roster-bulls-1996.tab",
   dataset  = "doi:10.70122/FK2/HXJVJU",
   server   = "demo.dataverse.org",
   version = "3"
 )
}

cache_path()

cache_info()
}
