% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prms_to_str}
\alias{prms_to_str}
\title{Format Parameters as String}
\usage{
prms_to_str(x, prms = NULL, round_digits = NULL, sep = "=>", collapse = "\\n")
}
\arguments{
\item{x}{a \link{drift_dm}object or character vector for labels.}

\item{prms}{Numeric vector of values (used if \code{x} is character).}

\item{round_digits}{Rounding precision (default set by
\code{\link[=drift_dm_default_rounding]{drift_dm_default_rounding()}}).}

\item{sep}{Separator between names and values (default: "=>").}

\item{collapse}{String to separate each name-value pair (default: "\\n").}
}
\value{
A single formatted string with parameter names and values.
(e.g., "a => 0 \\n b => 1")
}
\description{
Converts parameter values into a formatted string.
}
\seealso{
\code{\link[=coef.drift_dm]{coef.drift_dm()}}, as the numeric
vector provided by this call is used when \code{x} is of type \link{drift_dm}
}
\keyword{internal}
