% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvd_api_functions.R
\name{cvd_indicator_metric_systemlevel_comparison}
\alias{cvd_indicator_metric_systemlevel_comparison}
\title{Indicator metric system level comparison}
\usage{
cvd_indicator_metric_systemlevel_comparison(
  metric_id = 1,
  time_period_id = 1,
  area_id = 50
)
}
\arguments{
\item{metric_id}{integer - the metric to return data for (compulsory)}

\item{time_period_id}{integer - the time period to return data for (compulsory)}

\item{area_id}{integer - the area to return data for (compulsory)}
}
\value{
Tibble of metric performance for the specified area and all other areas in the same system level in the time period
}
\description{
Returns data for the SystemLevel Comparison chart for provided metric, area
and time period. \code{Data} contains the target value as well as an array
\code{SystemLevels} which contains data grouped by system level.
}
\details{
CVD Prevent API documentation:
\href{https://bmchealthdocs.atlassian.net/wiki/spaces/CP/pages/317882369/CVDPREVENT+API+Documentation#\%2Findicator\%2FmetricSystemLevelComparison\%2F\%3Cmetric_ID\%3E}{Indicator metric system level comparison}
}
\examples{
# return performance for metric 'AF: DOAC & VitK' in people aged 40-59 years
# (metric ID 1270) in time period 17 for Salford South East PCN (area ID 705)
# and all other PCNs - truncated to a sample of four PCN performances:
cvd_indicator_metric_systemlevel_comparison(metric_id = 1270,
time_period_id = 17, area_id = 705) |>
  dplyr::filter(AreaID \%in\% c(705:709), !is.na(Value)) |>
  dplyr::select(SystemLevelName, AreaID, AreaName, Value)
}
\seealso{
\code{\link[=cvd_indicator_list]{cvd_indicator_list()}}, \code{\link[=cvd_indicator_metric_list]{cvd_indicator_metric_list()}}, \code{\link[=cvd_indicator]{cvd_indicator()}},
\code{\link[=cvd_indicator_tags]{cvd_indicator_tags()}}, \code{\link[=cvd_indicator_details]{cvd_indicator_details()}}, \code{\link[=cvd_indicator_sibling]{cvd_indicator_sibling()}},
\code{\link[=cvd_indicator_child_data]{cvd_indicator_child_data()}}, \code{\link[=cvd_indicator_data]{cvd_indicator_data()}}, \code{\link[=cvd_indicator_metric_data]{cvd_indicator_metric_data()}},
\code{\link[=cvd_indicator_raw_data]{cvd_indicator_raw_data()}}, \code{\link[=cvd_indicator_nationalarea_metric_data]{cvd_indicator_nationalarea_metric_data()}},
\code{\link[=cvd_indicator_priority_groups]{cvd_indicator_priority_groups()}}, \code{\link[=cvd_indicator_pathway_group]{cvd_indicator_pathway_group()}}, #
\code{\link[=cvd_indicator_group]{cvd_indicator_group()}}, \code{\link[=cvd_indicator_metric_timeseries]{cvd_indicator_metric_timeseries()}},
\code{\link[=cvd_indicator_person_timeseries]{cvd_indicator_person_timeseries()}},
\code{\link[=cvd_indicator_metric_area_breakdown]{cvd_indicator_metric_area_breakdown()}}
}
