% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeans.ct.R
\name{kmeans.ct}
\alias{kmeans.ct}
\title{Continuous-time k-means clustering}
\usage{
kmeans.ct(
  fdobj,
  k,
  common_trend = FALSE,
  init.pts = NULL,
  tol = 0.001,
  max.iter = 100
)
}
\arguments{
\item{fdobj}{continuous-time multivariate data set of class \code{"\link[fda]{fd}"}}

\item{k}{number of clusters}

\item{common_trend}{logical: Should the curves be centered with respect to the mean function?
Defaults to \code{FALSE}.}

\item{init.pts}{a set of k time points. The observations at these time points
serve as initial values for the k means. Randomly generated if not supplied.}

\item{tol}{convergence tolerance for the k means}

\item{max.iter}{maximum number of iterations}
}
\value{
Object of class "\code{kmeans.ct}", a list consisting of
\item{fdobj }{the supplied \code{fdobj}}
\item{means }{means of the k clusters}
\item{transitions }{transition points between segments}
\item{cluster }{cluster memberships in the segments defined by the transitions}
\item{size }{length of each cluster, i.e. sum of lengths of subintervals making up each cluster}
\item{totisd }{total integrated sum of distances from the overall mean; this is the analogue of \code{totss} from \code{link{kmeans}}}
\item{withinisd }{within-cluster integrated sum of distances, i.e. integrated sum of distances from each cluster mean}
\item{tot.withinisd }{total within-cluster integrated sum of distances, i.e. \code{sum(withinisd)}}
\item{betweenisd }{between-cluster integrated sum of distances, i.e. \code{totisd-tot.withinss}}
}
\description{
A continuous-time version of k-means clustering in which each cluster is a
time segments or set of time segments.
}
\examples{

\dontrun{

require(fda)
data(CanadianWeather)
daybasis <- create.bspline.basis(c(0,365), nbasis=55)
tempfd <- smooth.basis(day.5, CanadianWeather$dailyAv[,,"Temperature.C"], daybasis)$fd
kmtemp3 <- kmeans.ct(tempfd, 3)
plot(kmtemp3, axes=FALSE)
axesIntervals(); box()
plot(silhouette.ct(kmtemp3), axes=FALSE)
axesIntervals(); box()
}

}
\seealso{
\code{\link{kmeans}}, \code{\link{plot.kmeans.ct}}
}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
