% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.ct.R
\name{cor.ct}
\alias{cor.ct}
\title{Continuous-time correlation or cross-correlation matrix}
\usage{
cor.ct(fdobj1, fdobj2 = fdobj1, common_trend = FALSE)
}
\arguments{
\item{fdobj1}{continuous-time multivariate data set of class \code{"\link[fda]{fd}"}}

\item{fdobj2}{an optional second data set}

\item{common_trend}{logical: centering wrt mean function if \code{TRUE},
without centering if \code{FALSE} (the default)}
}
\value{
A matrix of (cross-) correlations
}
\description{
Computes the correlation matrix of a continuous-time multivariate
data set represented as an \code{\link[fda]{fd}} object; or the cross-correlation
matrix of two such data sets.
}
\examples{

\dontrun{

# Canadian temperature data

require(fda)
require(corrplot)
data(CanadianWeather)
daybasis <- create.fourier.basis(c(0,365), nbasis=55)
tempfd <- smooth.basis(day.5, CanadianWeather$dailyAv[,,"Temperature.C"], daybasis)$fd

## The following yields a matrix of correlations that are all near 1:
rawcor <- cor.ct(tempfd)
corrplot(rawcor, method = 'square', type = 'lower', tl.col="black", tl.cex = 0.6)
## This occurs due to a strong seasonal trend that is common to all stations
## Removing this common trend leads to a more interesting result:
dtcor  <- cor.ct(tempfd, common_trend = TRUE)
ord <- corrMatOrder(dtcor)
dtcord <- dtcor[ord,ord]
corrplot(dtcord, method = 'square', type = 'lower', tl.col="black", tl.cex = 0.6)

}

}
\seealso{
\code{\link[fda]{center.fd}}, for centering of \code{"\link[fda]{fd}"} objects;  \code{\link{inprod.cent}}
}
\author{
Biplab Paul <paul.biplab497@gmail.com> and Philip Tzvi Reiss <reiss@stat.haifa.ac.il>
}
