% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{computeRandomSelection}
\alias{computeRandomSelection}
\title{Compute a random selection}
\usage{
computeRandomSelection(dist, requiredN, preselected, seed)
}
\arguments{
\item{dist}{distance matrix, used for distances and implicitly defining the set of entries}

\item{requiredN}{the required size of the random selection}

\item{preselected}{a list of preselected entries, referring to the row/column of \code{dist}}

\item{seed}{the applied seed for the randomizer}
}
\description{
The function \code{computeRandomSelection} is used internally by
the \code{\link{CoreCollection}} object.
}
\details{
This function returns a random selection of approximately size
\code{requiredN} by choosing entries sequentually and randomly, while excluding all entries
within a certain radius of an entry chosen before, and by finding iteratively the most
appropiate radius to end up with a number close to \code{requiredN} of selected entries.
}
\keyword{internal}
