# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute a random selection
#'
#' The function \code{computeRandomSelection} is used internally by
#' the \code{\link{CoreCollection}} object.
#'
#' This function returns a random selection of approximately size
#' \code{requiredN} by choosing entries sequentually and randomly, while excluding all entries
#' within a certain radius of an entry chosen before, and by finding iteratively the most
#' appropiate radius to end up with a number close to \code{requiredN} of selected entries.
#'
#' @param dist distance matrix, used for distances and implicitly defining the set of entries
#' @param requiredN the required size of the random selection
#' @param preselected a list of preselected entries, referring to the row/column of \code{dist}
#' @param seed the applied seed for the randomizer
#'
#' @keywords internal
#'
computeRandomSelection <- function(dist, requiredN, preselected, seed) {
    .Call('_coreCollection_computeRandomSelection', PACKAGE = 'coreCollection', dist, requiredN, preselected, seed)
}

#' Compute selection - recompute method
#'
#' The function \code{computeAdjustedSelectionUsingRecomputeMethod} is used internally by
#' the \code{\link{CoreCollection}} object to compute an adjusted selection using the recompute
#' method.
#'
#' This function returns a list describing for each of the row/columns entries of \code{dist} the
#' closest selected entry. The entries are implicetly defined by the row/columns of
#' \code{dist} and referred to by a zero-based integer describing the position.
#'
#' @param dist distance matrix, used for distances and implicitly defining the set of entries
#' @param adjustedSelected the selected entries defined as a list of zero-based integers referring to the row/columns of \code{dist}
#'
#' @keywords internal
#'
computeAdjustedSelectionUsingRecomputeMethod <- function(dist, adjustedSelected) {
    .Call('_coreCollection_computeAdjustedSelectionUsingRecomputeMethod', PACKAGE = 'coreCollection', dist, adjustedSelected)
}

#' Compute selection - split method
#'
#' The function \code{computeAdjustedSelectionUsingSplitMethod} is used internally by
#' the \code{\link{CoreCollection}} object to compute an adjusted selection using the split
#' method.
#'
#' This function returns a list describing for each of the row/columns entries of \code{dist} the
#' corresponding entry referred to in \code{groups}. However, groups with one or multiple
#' \code{preselected} entries are divided, and the returned list wil contain references to
#' the closest preselected entry within this group, implying a split if multiple preselected
#' entries occur within one group. The entries are implicetly defined by the row/columns of
#' \code{dist} and referred to by a zero-based integer describing the position.
#'
#' @param dist distance matrix, used for distances and implicitly defining the set of entries
#' @param groups the initial division into group defined as a list of zero-based integers referring to the row/columns of \code{dist}
#' @param preselected the set of preselected entries
#'
#' @keywords internal
#'
computeAdjustedSelectionUsingSplitMethod <- function(dist, groups, preselected) {
    .Call('_coreCollection_computeAdjustedSelectionUsingSplitMethod', PACKAGE = 'coreCollection', dist, groups, preselected)
}

#' Compute the core
#'
#' The function \code{computeCore} is used internally by
#' the \code{\link{CoreCollection}} object to compute the core.
#'
#' The \code{A-NE} method requires the core to minimize the average distance between each accession and
#' the nearest entry within the core. The \code{E-NE} method requires the core to maximize the
#' average distance between each core entry and its nearest neighbouring entry within the core.
#' The \code{E-E} method requires the core to maximize the average distance between all core entries.
#'
#' @param algorithm applied algorithm to find solution with method: currently, only \code{randomDescent} is available
#' @param method required method for choosing the entries within the groups: \code{A-NE} (accession nearest entry), \code{E-NE} (entry nearest entry) or \code{E-E} (entry entry)
#' @param dist distance matrix, used for distances and implicitly defining the set of entries
#' @param groups the initially created subdivision into groups
#'
#' @keywords internal
#'
computeCore <- function(algorithm, method, dist, groups) {
    .Call('_coreCollection_computeCore', PACKAGE = 'coreCollection', algorithm, method, dist, groups)
}

computeMeasure <- function(method, dist, c) {
    .Call('_coreCollection_computeMeasure', PACKAGE = 'coreCollection', method, dist, c)
}

