% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrasts_polynomial.R
\name{orth_polynomial_code}
\alias{orth_polynomial_code}
\alias{polynomial_code}
\title{Orthogonal Polynomial code}
\usage{
orth_polynomial_code(n)

polynomial_code(n)
}
\arguments{
\item{n}{Integer umber of factor levels to compute contrasts for.}
}
\value{
A contrast matrix with dimensions n rows and (n-1) columns.
}
\description{
Wrapper around \code{\link[stats:contrast]{stats::contr.poly()}}. You can also use \code{\link[=polynomial_code]{polynomial_code()}}
as an alias.
}
\details{
For n levels of factors where k in 1:n, generate a matrix with n-1
comparisons where each comparison looks for a polynomial trend of degree k
where each polynomial is independent of the others.
}
\examples{

mydf <- data.frame(
  grp = rep(c("a", "b", "c", "d"), each = 2000),
  val = c(
    rnorm(200, 2, 1),
    rnorm(200, 5, 1),
    rnorm(200, 7.5, 1),
    rnorm(200, 15, 1)
  )
) |>
  set_contrasts(grp ~ polynomial_code)

stats::lm(val ~ grp, data = mydf)

}
