% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/palette_check.R
\name{palette_check}
\alias{palette_check}
\title{Compare Palette with Color Vision Deficiencies}
\usage{
palette_check(
  x,
  tolerance = NULL,
  plot = FALSE,
  bivariate = FALSE,
  severity = 1,
  ...
)
}
\arguments{
\item{x}{A vector of hexadecimal color descriptions}

\item{tolerance}{The minimal value of acceptable difference between the colors to distinguish between them. As the default, minimal distance between colors in the original input palette is given.}

\item{plot}{If TRUE, display a plot comparing the original input palette and simulations of color vision deficiencies - deuteranopia, protanopia, and tritanopia}

\item{bivariate}{If TRUE (and plot = TRUE), display a bivariate plot (plot where colors are located in columns and rows) comparing the original input palette and simulations of color vision deficiencies - deuteranopia, protanopia, and tritanopia}

\item{severity}{Severity of the color vision defect, a number between 0 and 1}

\item{...}{Other arguments passed on to \code{\link[=palette_dist]{palette_dist()}} to control the color metric}
}
\value{
A data.frame with 4 observations and 8 variables:
\itemize{
\item name: orginal input color palette (normal), deuteranopia, protanopia, and tritanopia
\item n: number of colors
\item tolerance: minimal value of acceptable difference between the colors to distinguish between them
\item ncp: number of color pairs
\item ndcp: number of differentiable color pairs (color pairs with distances above the tolerance value)
\item min_dist: minimal distance between colors
\item mean_dist: average distance between colors
\item max_dist: maximal distance between colors
}

Additionally, a plot comparing the original input palette and simulations of color vision deficiencies - deuteranopia, protanopia, and tritanopia can be shown.
}
\description{
Comparision of the original input palette and simulations of color vision deficiencies - deuteranopia, protanopia, and tritanopia.
}
\examples{
rainbow_pal = rainbow(n = 7)
rainbow_pal
palette_check(rainbow_pal, plot = TRUE)

x = rcartocolor::carto_pal(11, "Vivid")
palette_check(x)
palette_check(x, plot = TRUE)
palette_check(x, tolerance = 1)
palette_check(x, tolerance = 10, metric = 1976)
palette_check(x, plot = TRUE, severity = 0.5)

y = rcartocolor::carto_pal(4, "Sunset")
palette_check(y, plot = TRUE, bivariate = TRUE, severity = 0.5)
}
