% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qqnormGpu.R
\name{qqnormGpu}
\alias{qqnormGpu}
\title{qqnormGpu}
\usage{
qqnormGpu(
  y,
  ylim,
  mu = 0,
  sigma = 1,
  lower.tail = 1,
  main = "Normal Q-Q Plot",
  xlab = "Theoretical Quantiles",
  ylab = "Sample Quantiles",
  Nglobal = getOption("clrng.Nglobal"),
  Nlocal = c(2, 2),
  type = getOption("clrng.type"),
  verbose = FALSE,
  ...
)
}
\arguments{
\item{y}{data sample.}

\item{ylim}{limits on the plot region.}

\item{mu}{mean of Normal distribution, default is 0.}

\item{sigma}{variance of Normal distribution, default is 1.}

\item{lower.tail}{a logical value specifying whether use lower tail probability, default is TRUE.}

\item{main}{plot label.}

\item{xlab}{plot label.}

\item{ylab}{plot label.}

\item{Nglobal}{a (non-empty) integer vector specifying size of work items for use, with default value from global option 'clrng.Nglobal'.}

\item{Nlocal}{a (non-empty) integer vector specifying size of local group size of the index space, default is c(2,2).}

\item{type}{a character string specifying "double" or "float" of random numbers, with default value from global option 'clrng.type'.}

\item{verbose}{a logical value, if TRUE, print extra information, default is FALSE.}

\item{...}{other graphical parameters.}
}
\value{
a Normal Q-Q plot.
}
\description{
Calculate quantiles on a GPU and produce a Q-Q plot in R.
}
\examples{
library(clrng)
if (detectGPUs() >= 1) {
setContext(grep("gpu", listContexts()$device_type)[1])
y <- stats::rt(256, df = 5)  # generates 256 random numbers from a Student's t-distribution
clrng::qqnormGpu(y, ylim=c(-4,5), mu=0, sigma=1, Nglobal=c(16,4))
x<-stats::rnorm(256)
clrng::qqnormGpu(x, Nglobal=c(8,6)) } else {
  message("No GPU context available")
}

}
