% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_index.R
\name{calculate_index}
\alias{calculate_index}
\title{Calculate index based on conditions}
\usage{
calculate_index(.df, ..., .weight = 1, .na_replace = 0)
}
\arguments{
\item{.df}{A data frame}

\item{...}{Conditions to evaluate. See examples for more details.}

\item{.weight}{Weight for each condition, should be of length 1 or equal to the number of conditions.}

\item{.na_replace}{Value to replace \code{NA}, should be of length 1 or equal to the number of conditions.}
}
\value{
A numeric vector of index scores
}
\description{
Calculate an index based on multiple conditions. Each condition is evaluated and the
result is weighted and summed to produce the final index.
}
\examples{
df <- data.frame(x = c(1, 2, 3, 4, 5), y = c(1, 2, NA, 4, NA))
calculate_index(df, x > 3, y < 3, .weight = c(1, 2), .na_replace = 0)
}
