% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TerminatorStagnation.R
\name{mlr_terminators_stagnation}
\alias{mlr_terminators_stagnation}
\alias{TerminatorStagnation}
\title{Terminator that stops when optimization does not improve}
\description{
Class to terminate the optimization after the performance stagnates, i.e.
does not improve more than \code{threshold} over the last \code{iters} iterations.
}
\section{Dictionary}{

This \link{Terminator} can be instantiated via the
\link[mlr3misc:Dictionary]{dictionary} \link{mlr_terminators} or with the associated
sugar function \code{\link[=trm]{trm()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{mlr_terminators$get("stagnation")
trm("stagnation")
}\if{html}{\out{</div>}}
}

\section{Parameters}{

\describe{
\item{\code{iters}}{\code{integer(1)}\cr
Number of iterations to evaluate the performance improvement on, default
is 10.}
\item{\code{threshold}}{\code{numeric(1)}\cr
If the improvement is less than \code{threshold}, optimization is stopped,
default is \code{0}.}
}
}

\examples{
TerminatorStagnation$new()
trm("stagnation", iters = 5, threshold = 1e-5)
}
\seealso{
Other Terminator: 
\code{\link{Terminator}},
\code{\link{mlr_terminators}},
\code{\link{mlr_terminators_clock_time}},
\code{\link{mlr_terminators_combo}},
\code{\link{mlr_terminators_evals}},
\code{\link{mlr_terminators_none}},
\code{\link{mlr_terminators_perf_reached}},
\code{\link{mlr_terminators_run_time}},
\code{\link{mlr_terminators_stagnation_batch}},
\code{\link{mlr_terminators_stagnation_hypervolume}}
}
\concept{Terminator}
\section{Super class}{
\code{\link[bbotk:Terminator]{bbotk::Terminator}} -> \code{TerminatorStagnation}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TerminatorStagnation-new}{\code{TerminatorStagnation$new()}}
\item \href{#method-TerminatorStagnation-is_terminated}{\code{TerminatorStagnation$is_terminated()}}
\item \href{#method-TerminatorStagnation-clone}{\code{TerminatorStagnation$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="format"><a href='../../bbotk/html/Terminator.html#method-Terminator-format'><code>bbotk::Terminator$format()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="print"><a href='../../bbotk/html/Terminator.html#method-Terminator-print'><code>bbotk::Terminator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="remaining_time"><a href='../../bbotk/html/Terminator.html#method-Terminator-remaining_time'><code>bbotk::Terminator$remaining_time()</code></a></span></li>
<li><span class="pkg-link" data-pkg="bbotk" data-topic="Terminator" data-id="status"><a href='../../bbotk/html/Terminator.html#method-Terminator-status'><code>bbotk::Terminator$status()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorStagnation-new"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorStagnation-new}{}}}
\subsection{Method \code{new()}}{
Creates a new instance of this \link[R6:R6Class]{R6} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorStagnation$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorStagnation-is_terminated"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorStagnation-is_terminated}{}}}
\subsection{Method \code{is_terminated()}}{
Is \code{TRUE} iff the termination criterion is positive, and \code{FALSE}
otherwise.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorStagnation$is_terminated(archive)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{archive}}{(\link{Archive}).}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{logical(1)}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TerminatorStagnation-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TerminatorStagnation-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TerminatorStagnation$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
