% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-methods.R
\name{components.bage_mod}
\alias{components.bage_mod}
\title{Extract Values for Hyper-Parameters}
\usage{
\method{components}{bage_mod}(object, quiet = FALSE, original_scale = FALSE, ...)
}
\arguments{
\item{object}{Object of class \code{"bage_mod"},
typically created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{quiet}{Whether to suppress messages.
Default is \code{FALSE}.}

\item{original_scale}{Whether values for
\code{"effect"}, \code{"trend"}, \code{"season"},
\code{"error"} and \code{"disp"} components from
a \link[=mod_norm]{normal} model are on the original
scale or the transformed scale. Default is \code{FALSE}.}

\item{...}{Unused. Included for generic consistency only.}
}
\value{
A \link[tibble:tibble-package]{tibble}
with four columns columns:

The return value contains the following columns:
\itemize{
\item \code{term} Model term that the hyper-parameter belongs to.
\item \code{component} Component within term.
\item \code{level} Element within component .
\item \code{.fitted} An \link[rvec:rvec]{rvec} containing
draws from the posterior distribution.
}
}
\description{
Extract values for hyper-parameters
from a model object. Hyper-parameters include
\itemize{
\item main effects and interactions,
\item dispersion,
\item trends, seasonal effects, errors,
\item SVD, spline, and covariate coefficients,
\item standard deviations, correlation coefficients.
}
}
\section{Fitted vs unfitted models}{


\code{components()} is typically called on a \link[=fit]{fitted}
model. In this case, the values returned are
draws from the joint posterior distribution for the
hyper-parameters in the model.

\code{components()} can, however, be called on an
unfitted model. In this case, the values returned
are draws from the joint \emph{prior} distribution.
In other words, the values incorporate
model priors, and any \code{exposure}, \code{size}, or \code{weights}
argument, but not observed outcomes.
}

\section{Scaling and Normal models}{


Internally, models created with \code{\link[=mod_norm]{mod_norm()}}
are fitted using transformed versions of the
outcome and weights variables. By default, when \code{components()}
is used with these models,
it returns values for \code{.fitted}
that are based on the transformed versions.
To instead obtain values for \code{"effect"}, \code{"trend"}, \code{"season"},
\code{"error"} and \code{"disp"} that are based on the
untransformed versions,
set \code{original_scale} to \code{TRUE}.
}

\examples{
set.seed(0)

## specify model
mod <- mod_pois(injuries ~ age + sex + year,
                data = nzl_injuries,
                exposure = popn)

## extract prior distribution
## of hyper-parameters
mod |>
  components()

## fit model
mod <- mod |>
  fit()

## extract posterior distribution
## of hyper-parameters
mod |>
  components()

## fit normal model
mod <- mod_norm(value ~ age * diag + year,
                data = nld_expenditure,
                weights = 1) |>
  fit()

## dispersion (= standard deviation in normal model)
## on the transformed scale
mod |>
  components() |>
  subset(component == "disp")

## disperson on the original scale
mod |>
  components(original_scale = TRUE) |>
  subset(component == "disp")
}
\seealso{
\itemize{
\item \code{\link[=augment]{augment()}} Extract values for rates,
means, or probabilities,
together with original data
\item \code{\link[=tidy]{tidy()}} Extract a one-line summary of a model
\item \code{\link[=mod_pois]{mod_pois()}} Specify a Poisson model
\item \code{\link[=mod_binom]{mod_binom()}} Specify a binomial model
\item \code{\link[=mod_norm]{mod_norm()}} Specify a normal model
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=is_fitted]{is_fitted()}} See if a model has been fitted
\item \code{\link[=unfit]{unfit()}} Reset a model
}
}
