% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dotAIFEBertTransfomer.R
\name{.AIFEBertTransformer}
\alias{.AIFEBertTransformer}
\title{Child \code{R6} class for creation and training of \code{BERT} transformers}
\description{
This class has the following methods:
\itemize{
\item \code{create}: creates a new transformer based on \code{BERT}.
\item \code{train}: trains and fine-tunes a \code{BERT} model.
}
}
\note{
This model uses a \code{WordPiece} tokenizer like \code{BERT} and can be trained with whole word masking. The transformer
library may display a warning, which can be ignored.
}
\section{Create}{
 New models can be created using the \code{.AIFEBertTransformer$create} method.
}

\section{Train}{
 To train the model, pass the directory of the model to the method \code{.AIFEBertTransformer$train}.

Pre-Trained models that can be fine-tuned using this method are available at \url{https://huggingface.co/}.

The model is trained using dynamic masking, as opposed to the original paper, which used static masking.
}

\references{
Devlin, J., Chang, M.‑W., Lee, K., & Toutanova, K. (2019). BERT: Pre-training of Deep Bidirectional
Transformers for Language Understanding. In J. Burstein, C. Doran, & T. Solorio (Eds.), Proceedings of the 2019
Conference of the North (pp. 4171--4186). Association for Computational Linguistics. \doi{10.18653/v1/N19-1423}

Hugging Face documentation
\itemize{
\item \url{https://huggingface.co/docs/transformers/model_doc/bert}
\item \url{https://huggingface.co/docs/transformers/model_doc/bert#transformers.BertForMaskedLM}
\item \url{https://huggingface.co/docs/transformers/model_doc/bert#transformers.TFBertForMaskedLM}
}
}
\seealso{
Other R6 classes for transformers: 
\code{\link{.AIFEBaseTransformer}},
\code{\link{.AIFEFunnelTransformer}},
\code{\link{.AIFELongformerTransformer}},
\code{\link{.AIFEMpnetTransformer}},
\code{\link{.AIFERobertaTransformer}}
}
\concept{R6 classes for transformers}
\section{Super class}{
\code{\link[aifeducation:.AIFEBaseTransformer]{aifeducation::.AIFEBaseTransformer}} -> \code{.AIFEBertTransformer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-.AIFEBertTransformer-new}{\code{.AIFEBertTransformer$new()}}
\item \href{#method-.AIFEBertTransformer-create}{\code{.AIFEBertTransformer$create()}}
\item \href{#method-.AIFEBertTransformer-train}{\code{.AIFEBertTransformer$train()}}
\item \href{#method-.AIFEBertTransformer-clone}{\code{.AIFEBertTransformer$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="init_transformer"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-init_transformer'><code>aifeducation::.AIFEBaseTransformer$init_transformer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_calculate_vocab"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_calculate_vocab'><code>aifeducation::.AIFEBaseTransformer$set_SFC_calculate_vocab()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_check_max_pos_emb"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_check_max_pos_emb'><code>aifeducation::.AIFEBaseTransformer$set_SFC_check_max_pos_emb()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_create_final_tokenizer"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_create_final_tokenizer'><code>aifeducation::.AIFEBaseTransformer$set_SFC_create_final_tokenizer()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_create_tokenizer_draft"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_create_tokenizer_draft'><code>aifeducation::.AIFEBaseTransformer$set_SFC_create_tokenizer_draft()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_create_transformer_model"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_create_transformer_model'><code>aifeducation::.AIFEBaseTransformer$set_SFC_create_transformer_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFC_save_tokenizer_draft"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFC_save_tokenizer_draft'><code>aifeducation::.AIFEBaseTransformer$set_SFC_save_tokenizer_draft()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFT_create_data_collator"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFT_create_data_collator'><code>aifeducation::.AIFEBaseTransformer$set_SFT_create_data_collator()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFT_cuda_empty_cache"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFT_cuda_empty_cache'><code>aifeducation::.AIFEBaseTransformer$set_SFT_cuda_empty_cache()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_SFT_load_existing_model"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_SFT_load_existing_model'><code>aifeducation::.AIFEBaseTransformer$set_SFT_load_existing_model()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_model_param"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_model_param'><code>aifeducation::.AIFEBaseTransformer$set_model_param()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_model_temp"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_model_temp'><code>aifeducation::.AIFEBaseTransformer$set_model_temp()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_required_SFC"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_required_SFC'><code>aifeducation::.AIFEBaseTransformer$set_required_SFC()</code></a></span></li>
<li><span class="pkg-link" data-pkg="aifeducation" data-topic=".AIFEBaseTransformer" data-id="set_title"><a href='../../aifeducation/html/.AIFEBaseTransformer.html#method-.AIFEBaseTransformer-set_title'><code>aifeducation::.AIFEBaseTransformer$set_title()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBertTransformer-new"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBertTransformer-new}{}}}
\subsection{Method \code{new()}}{
Creates a new transformer based on \code{BERT} and sets the title.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBertTransformer$new(init_trace = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{init_trace}}{\code{bool} option to show prints. If \code{TRUE} (by default) - messages will be shown, otherwise
(\code{FALSE}) - hidden.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method returns nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBertTransformer-create"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBertTransformer-create}{}}}
\subsection{Method \code{create()}}{
This method creates a transformer configuration based on the \code{BERT} base architecture and a
vocabulary based on \code{WordPiece} by using the python libraries \code{transformers} and \code{tokenizers}.

This method adds the following \emph{'dependent' parameters} to the base class's inherited \code{params} list:
\itemize{
\item \code{vocab_do_lower_case}
\item \code{num_hidden_layer}
}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBertTransformer$create(
  model_dir,
  text_dataset,
  vocab_size = 30522,
  vocab_do_lower_case = FALSE,
  max_position_embeddings = 512,
  hidden_size = 768,
  num_hidden_layer = 12,
  num_attention_heads = 12,
  intermediate_size = 3072,
  hidden_act = "GELU",
  hidden_dropout_prob = 0.1,
  attention_probs_dropout_prob = 0.1,
  sustain_track = FALSE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  trace = TRUE,
  pytorch_safetensors = TRUE,
  log_dir = NULL,
  log_write_interval = 2
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model_dir}}{\code{string} Path to the directory where the model should be saved. Allowed values: any}

\item{\code{text_dataset}}{\code{LargeDataSetForText} \link{LargeDataSetForText} Object storing textual data.}

\item{\code{vocab_size}}{\code{int} Size of the vocabulary. Allowed values: \verb{1000 <= x <= 5e+05}}

\item{\code{vocab_do_lower_case}}{\code{bool} \code{TRUE} if all words/tokens should be lower case.}

\item{\code{max_position_embeddings}}{\code{int} Number of maximum position embeddings. This parameter also determines the maximum length of a sequence which
can be processed with the model. Allowed values: \verb{10 <= x <= 4048}}

\item{\code{hidden_size}}{\code{int} Number of neurons in each layer. This parameter determines the dimensionality of the resulting text
embedding. Allowed values: \verb{1 <= x <= 2048}}

\item{\code{num_hidden_layer}}{\code{int} Number of hidden layers. Allowed values: \code{1 <= x }}

\item{\code{num_attention_heads}}{\code{int} determining the number of attention heads for a self-attention layer. Only relevant if \code{attention_type='multihead'} Allowed values: \code{0 <= x }}

\item{\code{intermediate_size}}{\code{int} determining the size of the projection layer within a each transformer encoder. Allowed values: \code{1 <= x }}

\item{\code{hidden_act}}{\code{string} Name of the activation function. Allowed values: 'gelu', 'relu', 'silu', 'gelu_new'}

\item{\code{hidden_dropout_prob}}{\code{double} Ratio of dropout. Allowed values: \verb{0 <= x <= 0.6}}

\item{\code{attention_probs_dropout_prob}}{\code{double} Ratio of dropout for attention probabilities. Allowed values: \verb{0 <= x <= 0.6}}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked during training via the python library 'codecarbon'.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable must be set if
sustainability should be tracked. A list can be found on Wikipedia:
\url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}. Allowed values: any}

\item{\code{sustain_region}}{\code{string} Region within a country. Only available for USA and Canada See the documentation of
codecarbon for more information. \url{https://mlco2.github.io/codecarbon/parameters.html} Allowed values: any}

\item{\code{sustain_interval}}{\code{int} Interval in seconds for measuring power usage. Allowed values: \code{1 <= x }}

\item{\code{trace}}{\code{bool} \code{TRUE} if information about the estimation phase should be printed to the console.}

\item{\code{pytorch_safetensors}}{\code{bool}
\itemize{
\item \code{TRUE}: a 'pytorch' model is saved in safetensors format.
\item \code{FALSE} (or 'safetensors' is not available): model is saved in the standard pytorch format (.bin).
}}

\item{\code{log_dir}}{\code{string} Path to the directory where the log files should be saved.
If no logging is desired set this argument to \code{NULL}. Allowed values: any}

\item{\code{log_write_interval}}{\code{int} Time in seconds determining the interval in which the logger should try to update
the log files. Only relevant if \code{log_dir} is not \code{NULL}. Allowed values: \code{1 <= x }}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method does not return an object. Instead, it saves the configuration and vocabulary of the new
model to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBertTransformer-train"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBertTransformer-train}{}}}
\subsection{Method \code{train()}}{
This method can be used to train or fine-tune a transformer based on \code{BERT} architecture with the
help of the python libraries \code{transformers}, \code{datasets}, and \code{tokenizers}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBertTransformer$train(
  output_dir,
  model_dir_path,
  text_dataset,
  p_mask = 0.15,
  whole_word = TRUE,
  val_size = 0.1,
  n_epoch = 1,
  batch_size = 12,
  chunk_size = 250,
  full_sequences_only = FALSE,
  min_seq_len = 50,
  learning_rate = 0.003,
  sustain_track = FALSE,
  sustain_iso_code = NULL,
  sustain_region = NULL,
  sustain_interval = 15,
  trace = TRUE,
  pytorch_trace = 1,
  pytorch_safetensors = TRUE,
  log_dir = NULL,
  log_write_interval = 2
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{\code{string} Path to the directory where the model should be saved. Allowed values: any}

\item{\code{model_dir_path}}{\code{string} Path to the directory where the original model is stored. Allowed values: any}

\item{\code{text_dataset}}{\code{LargeDataSetForText} \link{LargeDataSetForText} Object storing textual data.}

\item{\code{p_mask}}{\code{double} Ratio that determines the number of words/tokens used for masking. Allowed values: \verb{0 < x < 1}}

\item{\code{whole_word}}{\code{bool} * \code{TRUE}: whole word masking should be applied.
\itemize{
\item \code{FALSE}: token masking is used.
}}

\item{\code{val_size}}{\code{double} between 0 and 1, indicating the proportion of cases which should be
used for the validation sample during the estimation of the model.
The remaining cases are part of the training data. Allowed values: \verb{0 < x < 1}}

\item{\code{n_epoch}}{\code{int} Number of training epochs. Allowed values: \code{1 <= x }}

\item{\code{batch_size}}{\code{int} Size of the batches for training. Allowed values: \code{1 <= x }}

\item{\code{chunk_size}}{\code{int} Maximum length of every sequence. Must be equal or less the global maximum size
allowed by the model. Allowed values: \code{100 <= x }}

\item{\code{full_sequences_only}}{\code{bool} \code{TRUE} for using only chunks with a sequence length equal to \code{chunk_size}.}

\item{\code{min_seq_len}}{\code{int} Only relevant if \code{full_sequences_only = FALSE}. Value determines the minimal sequence length included in
training process.  Allowed values: \code{10 <= x }}

\item{\code{learning_rate}}{\code{double} Initial learning rate for the training. Allowed values: \verb{0 < x <= 1}}

\item{\code{sustain_track}}{\code{bool} If \code{TRUE} energy consumption is tracked during training via the python library 'codecarbon'.}

\item{\code{sustain_iso_code}}{\code{string} ISO code (Alpha-3-Code) for the country. This variable must be set if
sustainability should be tracked. A list can be found on Wikipedia:
\url{https://en.wikipedia.org/wiki/List_of_ISO_3166_country_codes}. Allowed values: any}

\item{\code{sustain_region}}{\code{string} Region within a country. Only available for USA and Canada See the documentation of
codecarbon for more information. \url{https://mlco2.github.io/codecarbon/parameters.html} Allowed values: any}

\item{\code{sustain_interval}}{\code{int} Interval in seconds for measuring power usage. Allowed values: \code{1 <= x }}

\item{\code{trace}}{\code{bool} \code{TRUE} if information about the estimation phase should be printed to the console.}

\item{\code{pytorch_trace}}{\code{int} \code{ml_trace=0} does not print any information about the training process from pytorch on the console. Allowed values: \verb{0 <= x <= 1}}

\item{\code{pytorch_safetensors}}{\code{bool}
\itemize{
\item \code{TRUE}: a 'pytorch' model is saved in safetensors format.
\item \code{FALSE} (or 'safetensors' is not available): model is saved in the standard pytorch format (.bin).
}}

\item{\code{log_dir}}{\code{string} Path to the directory where the log files should be saved.
If no logging is desired set this argument to \code{NULL}. Allowed values: any}

\item{\code{log_write_interval}}{\code{int} Time in seconds determining the interval in which the logger should try to update
the log files. Only relevant if \code{log_dir} is not \code{NULL}. Allowed values: \code{1 <= x }}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
This method does not return an object. Instead the trained or fine-tuned model is saved to disk.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-.AIFEBertTransformer-clone"></a>}}
\if{latex}{\out{\hypertarget{method-.AIFEBertTransformer-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{.AIFEBertTransformer$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
