% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{medianTune}
\alias{medianTune}
\title{Median heuristic}
\usage{
medianTune(samples, Z = NULL)
}
\arguments{
\item{samples}{An \eqn{N} by \eqn{d} matrix of samples from the target}

\item{Z}{(optional) An NxN matrix of square norms, which can be calculated
using \code{\link{squareNorm}}, as long as the \code{nystrom_inds} are \code{NULL}.}
}
\value{
The median heuristic, which can then be used as the length-scale parameter in the Gaussian, Matern and rational quadratic kernels
}
\description{
This function calculates the median heuristic for use in e.g. the Gaussian, Matern and rational quadratic kernels.
}
\references{
Garreau, D., Jitkrittum, W. and Kanagawa, M. (2017). Large sample analysis of the median heuristic.  \url{https://arxiv.org/abs/1707.07269}
}
\seealso{
See \code{\link{medianTune}} and \code{\link{K0_fn}} for functions which use this.
}
\author{
Leah F. South
}
