% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input_f.R
\name{pick_psa}
\alias{pick_psa}
\title{Helper function to create a list with random draws or whenever a series of functions needs to be called. Can be implemented within \code{pick_val_v}.}
\usage{
pick_psa(f, ...)
}
\arguments{
\item{f}{A string or vector of strings with the function to be called, e.g., "rnorm"}

\item{...}{parameters to be passed to the function (e.g., if "rnorm", arguments \code{n}, \code{mean}, \code{sd})}
}
\value{
List with length equal to \code{f} of parameters called
}
\description{
Helper function to create a list with random draws or whenever a series of functions needs to be called. Can be implemented within \code{pick_val_v}.
}
\details{
This function can be used to pick values for the PSA within \code{pick_val_v.}

The function will ignore NA items within the respective parameter (see example below).
If an element in f is NA (e.g., a non PSA input) then it will return NA as its value
This feature is convenient when mixing distributions with different number of arguments, e.g., \code{rnorm} and \code{rgengamma}.

While it's slightly lower than individually calling each function, it makes the code easier to read and more transparent
}
\examples{
params <- list(
param=list("a","b"),
dist=list("rlnorm","rnorm"),
n=list(4,1),
a=list(c(1,2,3,4),1),
b=list(c(0.5,0.5,0.5,0.5),0.5),
dsa_min=list(c(1,2,3,4),2),
dsa_max=list(c(1,2,3,4),3)
)
pick_psa(params[["dist"]],params[["n"]],params[["a"]],params[["b"]])

#It works with functions that require different number of parameters
params <- list(
 param=list("a","b","c"),
 dist=list("rlnorm","rnorm","rgengamma"),
 n=list(4,1,1),
 a=list(c(1,2,3,4),1,0),
 b=list(c(0.5,0.5,0.5,0.5),0.5,1),
 c=list(NA,NA,0.2),
 dsa_min=list(c(1,2,3,4),2,1),
 dsa_max=list(c(1,2,3,4),3,3)
)

pick_psa(params[["dist"]],params[["n"]],params[["a"]],params[["b"]],params[["c"]])

#Can be combined with multiple type of functions and distributions if parameters are well located

params <- list(
param=list("a","b","c","d"),
dist=list("rlnorm","rnorm","rgengamma","draw_tte"),
n=list(4,1,1,1),
a=list(c(1,2,3,4),1,0,"norm"),
b=list(c(0.5,0.5,0.5,0.5),0.5,1,1),
c=list(NA,NA,0.2,0.5),
c=list(NA,NA,NA,NA), #NA arguments will be ignored
dsa_min=list(c(1,2,3,4),2,1,0),
dsa_max=list(c(1,2,3,4),3,3,2)
)
}
