% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{slide}
\alias{slide}
\title{slide}
\usage{
slide(
  y,
  orig,
  forecFun,
  ...,
  h = 12,
  step = 1,
  output = TRUE,
  window = NA,
  parallel = FALSE
)
}
\arguments{
\item{y}{a vector, a matrix or a list of time series}

\item{orig}{starting forecasting origin}

\item{forecFun}{user function that implements forecasting methods}

\item{...}{rest of inputs to forecFun function}

\item{h}{forecasting horizon}

\item{step}{observations ahead to move the forecasting origin}

\item{output}{output TRUE/FALSE}

\item{window}{fixed window width in number of observations (NA for non fixed)}

\item{parallel}{run forecasts in parallel}
}
\value{
A matrix with all the dimensions
}
\description{
Rolling forecasting of a matrix of time series
}
\details{
Takes time series and run forecasting methods implemented in function
forecFun h steps ahead along the time series y, starting at forecasting
origin orig, and moving step observations ahead. Forecasts may be run in parallel
by setting parallel to TRUE. A fixed window width may be
specified with input window. The output is of dimensions (h, nOrigs, nModels, nSeries)
}
\examples{
\dontrun{slide(AirPassengers, 100, forecFun)}
}
\seealso{
\code{\link{colMedians}}, \code{\link{rowMedians}}, \code{\link{tests}},
         \code{\link{sumStats}}, \code{\link{gaussTest}}, \code{\link{ident}},
         \code{\link{cusum}}, \code{\link{varTest}}, \code{\link{conv}},
         \code{\link{armaFilter}}, \code{\link{dif}}, \code{\link{roots}},
         \code{\link{zplane}}, \code{\link{acft}},
         \code{\link{plotSlide}}, \code{\link{Accuracy}}, \code{\link{tsDisplay}},
         \code{\link{size}}
}
\author{
Diego J. Pedregal
}
