% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/te_datastore.R
\name{save_expanded_data}
\alias{save_expanded_data}
\alias{save_expanded_data,te_datastore_datatable-method}
\title{Method to save expanded data}
\usage{
save_expanded_data(object, data)

\S4method{save_expanded_data}{te_datastore_datatable}(object, data)
}
\arguments{
\item{object}{An object of class \link[=te_datastore-class]{te_datastore} or a child class.}

\item{data}{A data frame containing the expanded trial data. The columns \code{trial_period} and \code{id} are present, which
may be used in methods to save the data in an optimal way, such as with indexes, keys or separate files.}
}
\value{
An updated \code{object} with the data stored. Notably \code{object@N} should be increased
}
\description{
This method is used internally by \link{expand_trials} to save the data to the "datastore" defined in
\link{set_expansion_options}.
}
\examples{
temp_dir <- tempfile("csv_dir_")
dir.create(temp_dir)
datastore <- save_to_csv(temp_dir)
data(vignette_switch_data)
save_expanded_data(datastore, vignette_switch_data[1:200, ])

# delete after use
unlink(temp_dir, recursive = TRUE)
}
