% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizeMatching.R
\encoding{UTF-8}
\name{VisualizeMatching}
\alias{VisualizeMatching}
\alias{VisualiseMatching}
\alias{PlotMatching}
\alias{DisplayMatching}
\title{Visualize a matching}
\usage{
VisualizeMatching(
  Func,
  tree1,
  tree2,
  setPar = TRUE,
  precision = 3L,
  Plot = plot.phylo,
  matchZeros = TRUE,
  plainEdges = FALSE,
  edge.cex = par("cex"),
  value.cex = edge.cex * 0.8,
  edge.frame = "rect",
  edge.width = 1,
  edge.color = "black",
  ...
)
}
\arguments{
\item{Func}{Function used to construct tree similarity.}

\item{tree1, tree2}{Trees of class \code{phylo}, with identical leaf labels.}

\item{setPar}{Logical specifying whether graphical parameters should be
set to display trees side by side.}

\item{precision}{Integer specifying number of significant figures to display
when reporting matching scores.}

\item{Plot}{Function to use to plot trees.}

\item{matchZeros}{Logical specifying whether to pair splits with zero
similarity (\code{TRUE}), or leave them unpaired (\code{FALSE}).}

\item{plainEdges}{Logical specifying whether to plot edges with a uniform
width and colour (\code{TRUE}), or whether to draw edge widths according to the
similarity of the associated splits (\code{FALSE}).}

\item{edge.cex}{Character expansion for edge labels.
If \code{FALSE}, suppress edge labels.}

\item{value.cex}{Character expansion for values on edge labels.
If \code{FALSE}, values are not displayed.}

\item{edge.frame}{Character specifying the kind of frame to be printed around
the text of the edge labels.  Choose an abbreviation of \code{"rect"}, \code{"circle"},
or \code{"none"}.}

\item{edge.width, edge.color, \dots}{Additional parameters to send to \code{Plot()}.}
}
\value{
\code{VisualizeMatching()} invisibly returns the matching of splits
between \code{tree1} and \code{tree2} (i.e.
\code{Func(tree1, tree2, reportMatching = TRUE)})
}
\description{
Depict the splits that are matched between two trees using a specified
\href{https://ms609.github.io/TreeDist/articles/Generalized-RF.html}{Generalized Robinson–Foulds}
similarity measure.
}
\details{
Note that when visualizing a Robinson–Foulds distance (using
\code{Func = RobinsonFouldsMatching}), matched splits are assigned a \emph{similarity}
score of 1, which is deducted from the total number of splits to calculate
the Robinson–Foulds \emph{distance}.  Unmatched splits thus contribute one to
total tree distance.
}
\examples{
tree1 <- TreeTools::BalancedTree(6)
tree2 <- TreeTools::PectinateTree(6)

VisualizeMatching(RobinsonFouldsMatching, tree1, tree2)
matching <- VisualizeMatching(SharedPhylogeneticInfo, tree1, tree2,
                              matchZeros = FALSE)
attributes(matching)
}
\author{
\href{https://orcid.org/0000-0001-5660-1727}{Martin R. Smith}
(\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
