% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsqca_ots_dts.R
\name{otSweep}
\alias{otSweep}
\title{OTS–QCA: Outcome threshold sweep}
\usage{
otSweep(
  dat,
  outcome = NULL,
  conditions = NULL,
  sweep_range,
  thrX,
  dir.exp = NULL,
  include = "?",
  incl.cut = 0.8,
  n.cut = 1,
  pri.cut = 0,
  extract_mode = c("first", "all", "essential"),
  return_details = TRUE,
  Yvar = NULL,
  Xvars = NULL
)
}
\arguments{
\item{dat}{Data frame containing the outcome and condition variables.}

\item{outcome}{Character. Outcome variable name. Supports negation with
tilde prefix (e.g., \code{"~Y"}) following QCA package conventions.}

\item{conditions}{Character vector. Names of condition variables.}

\item{sweep_range}{Numeric vector. Candidate thresholds for Y.}

\item{thrX}{Named numeric vector. Fixed thresholds for X variables,
with names matching \code{conditions}.}

\item{dir.exp}{Directional expectations for \code{minimize}.
If \code{NULL}, all set to 1.}

\item{include}{Inclusion rule for \code{minimize}.}

\item{incl.cut}{Consistency cutoff for \code{truthTable}.}

\item{n.cut}{Frequency cutoff for \code{truthTable}.}

\item{pri.cut}{PRI cutoff for \code{minimize}.}

\item{extract_mode}{Character. How to handle multiple solutions:
\code{"first"} (default), \code{"all"}, or \code{"essential"}.
See \code{\link{qca_extract}} for details.}

\item{return_details}{Logical. If \code{TRUE} (default), returns both
summary and detailed objects for use with \code{generate_report()}.}

\item{Yvar}{Deprecated. Use \code{outcome} instead.}

\item{Xvars}{Deprecated. Use \code{conditions} instead.}
}
\value{
If \code{return_details = FALSE}, a data frame with columns:
\itemize{
\item \code{thrY} — threshold for Y
\item \code{expression} — minimized solution expression
\item \code{inclS} — solution consistency
\item \code{covS} — solution coverage
\item (additional columns depending on \code{extract_mode})
}

If \code{return_details = TRUE}, a list with:
\itemize{
\item \code{summary} — the data frame above
\item \code{details} — per-Y-threshold list of
\code{thrY}, \code{thrX_vec}, \code{truth_table}, \code{solution}
}
}
\description{
Sweeps the threshold of the outcome Y while keeping the thresholds of
all X conditions fixed.
}
\examples{
# Load sample data
data(sample_data)

# Set fixed thresholds for conditions
thrX <- c(X1 = 7, X2 = 7, X3 = 7)

# Run outcome threshold sweep (standard)
result <- otSweep(
  dat = sample_data,
  outcome = "Y",
  conditions = c("X1", "X2", "X3"),
  sweep_range = 6:9,
  thrX = thrX
)
head(result$summary)

# Run with negated outcome (~Y)
# Analyzes conditions for Y < threshold
result_neg <- otSweep(
  dat = sample_data,
  outcome = "~Y",
  conditions = c("X1", "X2", "X3"),
  sweep_range = 6:9,
  thrX = thrX
)
head(result_neg$summary)
}
