% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Celltype_Annotation_Combined.R
\name{Celltype_Annotation_Combined}
\alias{Celltype_Annotation_Combined}
\title{Uses "marker_list" to generate combined plot for cell annotation}
\usage{
Celltype_Annotation_Combined(
  seurat_obj,
  gene_list,
  species,
  cluster_col = "seurat_clusters",
  assay = "RNA",
  save_path = NULL,
  colour_low = "white",
  colour_high = "navy"
)
}
\arguments{
\item{seurat_obj}{Enter the Seurat object with annotation columns such as
"seurat_cluster" in meta.data to be annotated.}

\item{gene_list}{A list of cells and corresponding gene controls, the name of
the list is cell type, and the first column of the list corresponds to markers.
Lists can be generated using functions such as "Markers_filter_Cellmarker2 ()",
"Markers_filter_PanglaoDB ()", "read_excel_markers ()", "read_seurat_markers ()", etc.}

\item{species}{This parameter selects the species "Human" or "Mouse" for standard
gene format correction of markers entered by "Marker_list".}

\item{cluster_col}{Enter annotation columns such as "seurat_cluster" in meta.data
of the Seurat object to be annotated. Default parameters use "cluster_col =
'seurat_clusters'".}

\item{assay}{Enter the assay used by the Seurat object, such as "RNA". Default
parameters use "assay = 'RNA'".}

\item{save_path}{The output path of the cell annotation picture. Example parameters
use "save_path = './SlimR/Celltype_annotation_Bar/'".}

\item{colour_low}{Color for lowest expression level. (default = "white")}

\item{colour_high}{Color for highest expression level. (default = "black")}
}
\value{
The cell annotation picture is saved in "save_path".
}
\description{
Uses "marker_list" to generate combined plot for cell annotation
}
\examples{
\dontrun{
Celltype_Annotation_Combined(seurat_obj = sce,
    gene_list = Markers_list,
    species = "Human",
    cluster_col = "seurat_clusters",
    assay = "RNA",
    save_path = file.path(tempdir(),"SlimR_Celltype_Annotation_Combined"),
    colour_low = "white",
    colour_high = "navy"
    )
    }

}
\seealso{
Other Semi_Automated_Annotation_Workflow: 
\code{\link{Celltype_Annotation_Features}()},
\code{\link{Celltype_Annotation_Heatmap}()}
}
\concept{Semi_Automated_Annotation_Workflow}
