% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{clean_shark4r_cache}
\alias{clean_shark4r_cache}
\title{Clean SHARK4R cache by file age and session}
\usage{
clean_shark4r_cache(
  days = 1,
  cache_dir = tools::R_user_dir("SHARK4R", "cache"),
  clear_perm_cache = FALSE,
  search_pattern = NULL,
  verbose = TRUE
)
}
\arguments{
\item{days}{Numeric; remove files older than this number of days. Default is 1.}

\item{cache_dir}{Character; path to the cache directory to clean.
Defaults to the SHARK4R cache directory in the user-specific R folder
(via \code{tools::R_user_dir("SHARK4R", "cache")}). You can override this
parameter for custom cache locations.}

\item{clear_perm_cache}{Logical. If \code{TRUE}, filed that are cached across R sessions are cleared, i.e. geographical shape files.
Defaults to \code{FALSE}.}

\item{search_pattern}{Character; optional regex pattern to filter which files to consider for deletion.}

\item{verbose}{Logical. If \code{TRUE}, displays messages of cache cleaning progress. Defaults to \code{TRUE}.}
}
\value{
Invisible \code{NULL}. Messages are printed about what was deleted
and whether the in-memory session cache was cleared.
}
\description{
Deletes cached files in the SHARK4R cache directory that are older than
a specified number of days.
}
\details{
The cache is automatically cleared after 24h.
}
\examples{
\donttest{
  # Remove files older than 60 days and clear session cache
  clean_shark4r_cache(days = 60)
}
}
\seealso{
\code{\link[=get_peg_list]{get_peg_list()}}, \code{\link[=get_nomp_list]{get_nomp_list()}}, \code{\link[=get_shark_codes]{get_shark_codes()}}, \code{\link[=get_dyntaxa_dwca]{get_dyntaxa_dwca()}}, \code{\link[=get_shark_statistics]{get_shark_statistics()}}
for functions that populate the cache.
}
