% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{prune.SDTree}
\alias{prune.SDTree}
\title{Prune an SDTree}
\usage{
\method{prune}{SDTree}(object, cp, ...)
}
\arguments{
\item{object}{an SDTree object}

\item{cp}{Complexity parameter, the higher the value the more nodes are pruned.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
A pruned SDTree object
}
\description{
Removes all nodes that did not improve the loss by more than cp times the initial loss. 
Either by themselves or by one of their successors. Note that the tree is pruned in place.
If you intend to keep the original tree, make a copy of it before pruning.
}
\examples{
set.seed(1)
X <- matrix(rnorm(10 * 20), nrow = 10)
Y <- rnorm(10)
tree <- SDTree(x = X, y = Y)
pruned_tree <- prune(tree, 0.2)
tree
pruned_tree
}
\author{
Markus Ulmer
}
