% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_bar_plot.R
\name{create_bar_plot}
\alias{create_bar_plot}
\title{create_bar_plot}
\usage{
create_bar_plot(
  df = NULL,
  aes_x = NULL,
  aes_y = NULL,
  aes_color = NULL,
  aes_fill = NULL,
  position = "stack",
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  center_titles = FALSE,
  x_title = NULL,
  y_title = NULL,
  hide_x_tics = FALSE,
  hide_y_tics = FALSE,
  rot_x_tic_angle = 0,
  rot_y_tic_label = FALSE,
  bar_fill = NA,
  bar_color = "black",
  bar_alpha = 1,
  bar_lwd = 0.7,
  bar_width = NULL,
  x_major_breaks = NULL,
  y_limits = NULL,
  y_major_breaks = waiver(),
  y_minor_breaks = waiver(),
  y_labels = waiver(),
  axis_text_size = 11,
  do_coord_flip = FALSE,
  order_bars = NULL,
  bar_labels = FALSE,
  bar_label_sz = 4,
  bar_label_color = "black",
  bar_label_fontface = "plain",
  bar_label_alpha = 1,
  show_major_grids = TRUE,
  show_minor_grids = TRUE,
  panel_color = "white",
  panel_border_color = "black",
  show_legend = TRUE,
  legend_pos = "right",
  legend_key_width = 0.7,
  legend_key_height = 0.7,
  legend_key_backgrd = "white",
  silent_NA_warning = FALSE,
  png_file_path = NULL,
  png_width_height = c(480, 480)
)
}
\arguments{
\item{df}{The target data frame for the bar chart.}

\item{aes_x}{A required string that sets the x axis discrete variable name from 'df'.}

\item{aes_y}{Sets the y axis numeric variable name from 'df'. If this variable is \code{NULL}
the bar heights will be proportional to the number of cases in the levels of 'aes_x'.
If 'aes_y' is not \code{NULL}, the bar heights represent this parameter's values across the 'aes_x' levels.}

\item{aes_color}{Sets the variable name from 'df' for the aesthetic mapping for color.}

\item{aes_fill}{Sets the variable name from 'df' for the aesthetic mapping for fill.}

\item{position}{A string that sets the bar positions.  Acceptable values are "dodge"(side by side),
"identity"(overlap) or "stack".}

\item{title}{A string that sets the overall title.}

\item{subtitle}{A string that sets the overall subtitle.}

\item{caption}{A string that sets the caption.}

\item{center_titles}{A logical which if \code{TRUE} centers both the 'title' and 'subtitle'.}

\item{x_title}{A string that sets the x axis title. If \code{NULL} (the default) then the x axis title does not appear.}

\item{y_title}{A string that sets the y axis title. If \code{NULL} (the default) then the y axis title does not appear.}

\item{hide_x_tics}{A logical that controls the appearance of the x axis tics.}

\item{hide_y_tics}{A logical that controls the appearance of the y axis tics.}

\item{rot_x_tic_angle}{A numeric that sets the angle of rotation for the x tic label. When x tic labels are long,
a value of 40 for this argument usually works well.}

\item{rot_y_tic_label}{A logical which if TRUE rotates the y tic labels 90 degrees for enhanced readability.}

\item{bar_fill}{A string that sets the fill color attribute for the bars.}

\item{bar_color}{A string that sets the outline color attribute for the bars.}

\item{bar_alpha}{A numeric that sets the alpha component attribute to 'bar_color'.}

\item{bar_lwd}{A numeric that sets the bar's outline line width attribute.}

\item{bar_width}{A numeric that sets the width attribute of the bars.}

\item{x_major_breaks}{If 'aes_x' is numeric then this parameter is a numeric vector that defines the major
breaks/intervals for the x axis. Interval labels are created and their respective counts are displayed.}

\item{y_limits}{A numeric 2 element vector that sets the minimum and maximum for the y axis.
Use \code{NA} to refer to the existing minimum and maximum.}

\item{y_major_breaks}{A numeric vector or function that defines the exact major tic locations along the y axis.}

\item{y_minor_breaks}{A numeric vector or function that defines the exact minor tic locations along the y axis.}

\item{y_labels}{A character vector with the same length as 'y_major_breaks', that labels the major tics.}

\item{axis_text_size}{A numeric that sets the font size along the axis'. Default is 11.}

\item{do_coord_flip}{A logical which if \code{TRUE} will flip the x and y axis'.}

\item{order_bars}{A string which will order the bars in a specific direction. Acceptable values are "asc" or "desc"}

\item{bar_labels}{A logical which if \code{TRUE} will label each bar with its value.}

\item{bar_label_sz}{A numeric that sets the size of the label.}

\item{bar_label_color}{A string that sets the label's color.}

\item{bar_label_fontface}{A string that sets the label's font face. Acceptable values are "plain", "bold",
"italic", "bold.italic".}

\item{bar_label_alpha}{A numeric that sets the label's alpha value.}

\item{show_major_grids}{A logical that controls the appearance of major grids.}

\item{show_minor_grids}{A logical that controls the appearance of minor grids.}

\item{panel_color}{A string in hexidecimal or color name that sets the plot panel's color.
The default is "white".}

\item{panel_border_color}{A string in hexidecimal or color name that sets the plot panel's border color.
The default is "black".}

\item{show_legend}{A logical that controls the appearance of the legend.}

\item{legend_pos}{A string that sets the legend position. Acceptable values are
"top", "bottom", "left", "right".}

\item{legend_key_width}{A numeric that sets the legend width in cm.}

\item{legend_key_height}{A numeric that sets the legend height in cm.}

\item{legend_key_backgrd}{A string that sets the legend's background color.}

\item{silent_NA_warning}{A logical that controls the appearance of a console warning when Na's
are removed.}

\item{png_file_path}{A character string with the directory and file name to produce
a png image of the plot.}

\item{png_width_height}{A numeric vector that sets the width and height of the png image in pixels. The
default is c(480,480).  There are 37.8 pixels in a centimeter.}
}
\value{
A ggplot class object.
}
\description{
Function wraps ggplot2 geom_bar and geom_col to creates a bar plot.
}
\examples{
library(ggplot2)
library(data.table)
library(RColorBrewer)
library(RplotterPkg)

RplotterPkg::create_bar_plot(
  df = RplotterPkg::religion,
  aes_x = "happy",
  aes_fill = "religion",
  position = "dodge",
  title = "Happy Religions",
  center_titles = TRUE,
  rot_y_tic_label = TRUE,
  bar_width = 0.8,
  order_bars = "desc",
  x_title = "Happiness",
  y_title = "Count",
  axis_text_size = 16
) +
ggplot2::scale_fill_discrete(
  type = RColorBrewer::brewer.pal(n = 9, name = "Set1")
)

}
