% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsa.download.data.r
\name{lsa.download.data}
\alias{lsa.download.data}
\title{Download large-scale assessment and survey data}
\usage{
lsa.download.data(
  study,
  cycle,
  POP,
  ISO,
  out.folder,
  append = TRUE,
  convert = TRUE,
  missing.to.NA = FALSE
)
}
\arguments{
\item{study}{String, large-scale assessment or study name. See details.}

\item{cycle}{Numeric, study year of administration (cycle). See details.}

\item{POP}{String, population of interest. If none is provide, default is taken.
See details.}

\item{ISO}{Vector containing character ISO codes of the countries' data files to
include in the merged file. See details.}

\item{out.folder}{Path to the folder where the downloaded (and optionally converted) files
will be stored. If the final folder in the path does not exist, it will
be created.}

\item{append}{If some files for the study, cycle, populations and countries have
already been downloaded, download only the new ones.
(default is \code{TRUE}). See details.}

\item{convert}{Logical, shall the data be converted to \code{lsa.data} and stored in
\code{.RData} files (default) after being downloaded. See details.}

\item{missing.to.NA}{Logical, should the user-defined missing values be converted to \code{NA}
when converting the downloaded data  (default is \code{FALSE})?
See \code{lsa.convert.data}.}
}
\value{
If \code{convert = FALSE}, the function will return the originally downloaded data files (SPSS or ASCII textt with \code{.sps} control files) for the study, cycle, countries and population defined in the respective arguments, stored in the directory specified in \code{out.folder}. If \code{convert = TRUE} (default), converted \code{.RData} data files, containing an object with class \code{lsa.data}, an extension of the \code{data.table} class, will be saved in the directory defined by \code{out.folder} and the original downloaded SPSS data files will be removed.
}
\description{
Downloads data files from large-scale assessments' and surveys' data repositories on the web and, if desired, converts them to \code{lsa.data} format and stores them in .RData files.
}
\details{
The \code{lsa.download.data} function downloads large-scale assessments' and surveys' data files from data repositories on the web. This is a convenience function that saves time and efforts for the user. IEA studies, as well as OECD TALIS and TALIS 3S, provide their data in SPSS \code{.sav} format with same or very similar structure: one file per country and type of respondent (e.g. school principal, student, teacher, etc.) per population. For IEA studies and OECD TALIS and TALIS 3S use the \code{ISO} argument to specify the countries' three-letter ISO codes whose data is to be downloaded. The three-letter ISO codes for each country can be found in the user guide for the study in scope. For example, the ISO codes of the countries participating in PIRLS 2016 can be found in its user guide on pages 52-54. To download the files from all countries for an IEA study and OECD TALIS and TALIS 3S, simply omit the \code{ISO} argument, this will download files for all countries for the population in \code{POP} in the \code{study} and \code{cycle}. The \code{ISO} argument will not work for PISA files, as all data for all countries is provided within a single file per respondent type. If \code{ISO} is provided anyway, it will be ignored. Note that as of now, the function downloads PISA databases only from its latest cycles - 2015, 2018 and 2022.

When all desired SPSS data files are downloaded, the function converts them to \code{lsa.data} objects and stores them as .RData files on the disk, removing the data files downloaded in their original (SPSS) format. This is the default behavior which can be overridden by setting \code{convert = FALSE}.

The \code{study} argument defines the study for which data shall be downloaded. The acceptable strings are as follows:

\itemize{
\item \code{CivED} - IEA Civic and Citizenship Education study (CivED)
\item \code{ICCS} - IEA International Civic and Citizenship Education Study (ICCS)
\item \code{ICILS} - IEA International Computer and Information Literacy Study (ICILS)
\item \code{PIRLS} - IEA Progress in International Reading Literacy Study (PIRLS)
\item \code{prePIRLS} - IEA PIRLS Literacy (prePIRLS)
\item \code{REDS} - IEA Responses to Educational Disruption Survey (REDS)
\item \code{RLII} - IEA Reading Literacy Study (RL), second round
\item \code{SITES} - IEA Second Information Technology in Education Study (SITES)
\item \code{TIMSS} - IEA Trends in International Mathematics and Science Study (TIMSS)
\item \code{preTIMSS} - IEA TIMSS Numeracy (TIMSS)
\item \code{eTIMSS PSI} - IEA TIMSS with PSI items (TIMSS)
\item \code{TIMSS Advanced Mathematics}/\code{TIMSS Advanced Physics} - IEA Trends in International Mathematics and Science Study in Mathematics and Physics (TIMSS Advanced)
\item \code{TiPi} - IEA joint TIMSS and PIRLS 2011 study
\item \code{PISA} - OECD Programme for International Student Assessment (PISA)
\item \code{PISA D} - OECD Programme for International Student Assessment for low- and middle-income countries (PISA for Development)
\item \code{TALIS} - OECD Teaching and Learning International Survey (TALIS) and
\item \code{TALIS 3S} - OECD Starting Strong Teaching and Learning International Survey (TALIS Starting Strong Survey)
}

The \code{cycle} argument provides information about the year of administration of a particular study for which SPSS data files can be downloaded. A numeric value for a specific year of administration needs to be provided. Here is the list from all released cycles for all studies RALSA supports till now:

\itemize{
\item For \code{CivED} - \code{1999}
\item For \code{ICCS} - \code{2009}, \code{2016}, or \code{2022}
\item For \code{ICILS} - \code{2013}, \code{2018}, or \code{2023}
\item For \code{PIRLS} - \code{2001}, \code{2006}, \code{2011}, \code{2016}, or \code{2021}
\item For \code{prePIRLS} - \code{2016}
\item For \code{ePIRLS} - \code{2016}
\item For \code{REDS} - \code{2021}
\item For \code{RLII} - \code{1991} or \code{2001}
\item For \code{SITES} - \code{1998} or \code{2006}
\item For \code{TIMSS} - \code{1995}, \code{1998}, \code{2003}, \code{2007}, \code{2011}, \code{2015}, \code{2019} or \code{2023}
\item For \code{preTIMSS} - \code{2015}
\item For \code{eTIMSS PSI} - \code{2019}
\item For \code{TIMSS Advanced Mathematics}/\code{TIMSS Advanced Physics} - \code{1995}, \code{2008}, or \code{2015}
\item For \code{TiPi} - \code{2011}
\item For \code{PISA} - \code{2015}, \code{2018} or \code{2022}
\item For \code{PISA D} - \code{2019}
\item For \code{TALIS} - \code{2008}, \code{2013}, or \code{2018}
\item For \code{TALIS 3S} - \code{2018}
}

Note that the data from the IEA Teacher Education and Development Study in Mathematics (TEDS-M) is not freely available from the IEA website due to data confidentiality issues and is available only on \href{https://www.iea.nl/data-tools/repository/tedsm}{request from the IEA}.

Some studies (e.g. TIMSS and TALIS) have more than one population (i.e. students in grades 4 and 8 in TIMSS and teachers in different ISCED levels in TALIS). The \code{POP} argument is required for these studies, as the \code{lsa.download.data} needs to know data from which population is needed. The population strings for the \code{POP} argument for the pertinent studies are as follows:

\itemize{
\item \strong{CivED}:
\itemize{
\item \code{G8} (grade 8)
\item \code{G12} (grade 12)
}
\item \strong{ICCS}:
\itemize{
\item \code{G8} (grade 8)
\item \code{G9} (grade 9, ICCS 2009 only)
}
\item \strong{ICILS}:
\itemize{
\item \code{G8} (grade 8)
}
\item \strong{PIRLS}:
\itemize{
\item \code{G4} (grade 4)
}
\item \strong{prePIRLS}:
\itemize{
\item \code{G4} (grade 4)
}
\item \strong{ePIRLS}:
\itemize{
\item \code{G4} (grade 4)
}
\item \strong{REDS}:
\itemize{
\item \code{G8} (grade 8)
}
\item \strong{RLII}:
\itemize{
\item \code{G4} (grade 4)
}
\item \strong{SITES}:
\itemize{
\item \code{M1 POP A} (Module 1, 1998, population A)
\item \code{M1 POP B} (Module 1, 1998, population B)
\item \code{M1 POP C} (Module 1, 1998, population C)
\item \code{M2} (Module 2, 2006)
}
\item \strong{TIMSS}:
\itemize{
\item \code{G4} (grade 4)
\item \code{G8} (grade 8)
}
\item \strong{preTIMSS}:
\itemize{
\item \code{G4} (grade 4)
}
\item \strong{eTIMSS PSI}:
\itemize{
\item \code{G4} (grade 4)
\item \code{G8} (grade 8)
}
\item \strong{TIMSS Advanced Mathematics} / \strong{TIMSS Advanced Physics}:
\itemize{
\item \code{G12} (grade 12)
}
\item \strong{TiPi}:
\itemize{
\item \code{G4} (grade 4)
}
\item \strong{PISA}:
\itemize{
\item \code{Y15} (15-year-old)
}
\item \strong{PISA for Development}
\itemize{
\item \code{IS} (in school)
\item \code{OS} (out of school)
}
\item \strong{TALIS}:
\itemize{
\item \code{I1} (ISCED 1)
\item \code{I2} (ISCED 2)
\item \code{I3} (ISCED 3)
\item \code{P} (PISA schools)
}
\item \strong{TALIS 3S}:
\itemize{
\item \code{I0.2} (ISCED 0.2)
\item \code{IU3} (ISCED U3)
}
}

For the exact meaning of the population names, see the respective study documentation. Note that if \code{POP} is not provided, a default (first population for a study and/or a cycle) is applied.

The \code{out.folder} argument controls where the files shall be stored. Note that the files will \strong{not} download the files directly in the folder path provided to the argument. Instead, it will create a folder named as the study name, cycle and population and place the downloaded files there. Note that for IEA studies, OECD TALIS and TALIS 3S, if the download folder already exists and it contains data files for a given study, cycle and population for some of the countries, the function will only append the new files in it, keeping the ones that already exist there, if the \code{append} argument equals \code{TRUE} (default). This can save a lot of time if the user needs to download just the additional files instead of download everything again. If \code{append} argument equals \code{TRUE}, the existing files will be overwritten. For OECD PISA and PISA for Development the \code{append} argument will be ignored and, if the study folder in \code{out.folder} exists and contains any SPSS \code{.sav} or \code{.RData} files, the function will stop its execution and ask for moving the existing files.
}
\note{
\strong{It is not recommended to work further in the folder where the downloaded files reside, it is meant to be only for the downloaded (an possibly converted) files.}

In some study cycles (e.g. TIMSS 2019 and PIRLS 2021), there are the so-called "bridge studies". These aim to test the differences between electronic and paper testing modes. When a study cycle contains data files from a bridge study, these will be downloaded too for the countries that conducted the study electronically.

As of now, PISA data can be downloaded only for the 2015, 2018 and 2022 cycles.
}
\examples{
# Download and convert PIRLS 2016 data for Australia and Slovenia only and convert them
\dontrun{
lsa.download.data(study = "PIRLS", cycle = 2016, ISO = c("aus", "svn"), out.folder = "C:/Data")
}

# Same as the above, but download files for all countries
\dontrun{
lsa.download.data(study = "PIRLS", cycle = 2016, out.folder = "C:/Data")
}

# Download TIMSS 2019 data for grade 8 for South Africa and convert them
\dontrun{
lsa.download.data(study = "TIMSS", cycle = 2019, ISO = c("aus", "zaf"), POP = "Grade 8",
out.folder = "C:/Data")
}

# Download PISA 2012 data and covert them
\dontrun{
lsa.download.data(study = "PISA", cycle = 2012, out.folder = "C:/Data")
}


}
\references{
Foy, P. (Ed.). (2018). \emph{PIRLS 2016 User Guide for the International Database}. TIMSS & PIRLS International Study Center.
}
\seealso{
\code{\link{lsa.convert.data}}
}
