% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_sectional.R
\name{calc_market_breadth}
\alias{calc_market_breadth}
\title{Calculate Market Breadth Percentage}
\usage{
calc_market_breadth(condition_df, min_stocks = 10)
}
\arguments{
\item{condition_df}{Data frame with Date column and TRUE/FALSE values}

\item{min_stocks}{Minimum stocks required for valid calculation (default: 10)}
}
\value{
A \code{data.table} with \code{Date} and \code{Breadth_[Sector]} columns (0-100 scale)
}
\description{
Measures the percentage of stocks meeting a condition (market participation).
Useful for assessing market health and identifying broad vs narrow moves.
}
\examples{
# Percent of stocks above 200-day MA
data("sample_prices_weekly")
ma200 <- calc_moving_average(sample_prices_weekly, 200)
above_ma <- filter_above(calc_distance(sample_prices_weekly, ma200), 0)
breadth <- calc_market_breadth(above_ma)
}
