% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_sectional.R
\name{calc_relative_strength_rank}
\alias{calc_relative_strength_rank}
\title{Calculate Cross-Sectional Ranking of Indicators}
\usage{
calc_relative_strength_rank(
  indicator_df,
  method = c("percentile", "rank", "z-score")
)
}
\arguments{
\item{indicator_df}{Data frame with Date column and indicator values}

\item{method}{Ranking method: "percentile" (0-100), "rank" (1-N), or "z-score"}
}
\value{
Data frame with same structure containing ranks/scores
}
\description{
Ranks each stock's indicator value against all other stocks on the same date.
Enables relative strength strategies that adapt to market conditions. Optimized
using matrix operations for 15x speedup.
}
\examples{
# Rank RSI across all stocks
data("sample_prices_weekly")
rsi <- calc_rsi(sample_prices_weekly, 14)
rsi_ranks <- calc_relative_strength_rank(rsi, method = "percentile")

# Find relatively overbought (top 10\%)
relative_overbought <- filter_above(rsi_ranks, 90)
}
