% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Glm.R
\name{createGlmModel}
\alias{createGlmModel}
\title{createGlmModel}
\usage{
createGlmModel(
  coefficients,
  intercept = 0,
  mapping = "logistic",
  targetId = NULL,
  outcomeId = NULL,
  populationSettings = createStudyPopulationSettings(),
  restrictPlpDataSettings = createRestrictPlpDataSettings(),
  covariateSettings = FeatureExtraction::createDefaultCovariateSettings(),
  featureEngineering = NULL,
  tidyCovariates = NULL,
  requireDenseMatrix = FALSE
)
}
\arguments{
\item{coefficients}{A dataframe containing two columns, coefficients and
covariateId, both of type numeric. The covariateId column must contain
valid covariateIds that match those used in the \code{FeatureExtraction}
package.}

\item{intercept}{A numeric value representing the intercept of the model.}

\item{mapping}{A string representing the mapping from the
linear predictors to outcome probabilities. For generalized linear models
this is the inverse of the link function. Supported values is only
"logistic" for logistic regression model at the moment.}

\item{targetId}{Add the development targetId here}

\item{outcomeId}{Add the development outcomeId here}

\item{populationSettings}{Add development population settings (this includes the time-at-risk settings).}

\item{restrictPlpDataSettings}{Add development restriction settings}

\item{covariateSettings}{Add the covariate settings here to specify how the model covariates are created from the OMOP CDM}

\item{featureEngineering}{Add any feature engineering here (e.g., if you need to modify the covariates before applying the model)
This is a list of lists containing a string named funct specifying the engineering function to call and settings that are inputs to that
function. funct must take as input trainData (a plpData object) and settings (a list).}

\item{tidyCovariates}{Add any tidyCovariates mappings here (e.g., if you need to normalize the covariates)}

\item{requireDenseMatrix}{Specify whether the model needs a dense matrix (TRUE or FALSE)}
}
\value{
A model object containing the model (Coefficients and intercept)
and the prediction function.
}
\description{
Create a generalized linear model that can be used in the
PatientLevelPrediction package.
}
\examples{
coefficients <- data.frame(
  covariateId = c(1002),
  coefficient = c(0.05))
model <- createGlmModel(coefficients, intercept = -2.5)
data("simulationProfile")
plpData <- simulatePlpData(simulationProfile, n = 50, seed = 42)
prediction <- predictPlp(model, plpData, plpData$cohorts)
# see the predicted risk values
prediction$value
}
