% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/ParallelPC.R
\name{smcmig}
\alias{smcmig}
\title{The sequential Monte Carlo permutation test (smc-mi-g)}
\usage{
smcmig(x, y, S, suffStat)
}
\arguments{
\item{x,y,S}{It is tested, whether x and y are conditionally independent given the subset S of
the remaining nodes. x, y, S all are integers, corresponding to variable or node
numbers.}

\item{suffStat}{The data matrix with rows are samples and columns are variables.}
}
\value{
The p-value of the test.
}
\description{
The sequential Monte Carlo permutation test. See bnlearn package for more details.
}
\examples{
##########################################
## Using smcmig
##########################################
library(bnlearn)
library(pcalg)
data("gmG")
suffStat<-gmG$x
smcmig(1,2,3,suffStat)
}
\references{
Marco Scutari (2010). Learning Bayesian Networks with the bnlearn R Package. Journal of Statistical Software, 35(3), 1-22.
}

