% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tableRecordCount.R
\name{tableRecordCount}
\alias{tableRecordCount}
\title{Create a visual table from a summariseRecordCount() result.}
\usage{
tableRecordCount(result, type = "gt")
}
\arguments{
\item{result}{A summarised_result object.}

\item{type}{Type of formatting output table. See \code{visOmopResults::tableType()} for allowed options. Default is \code{"gt"}.}
}
\value{
A formatted table object with the summarised data.
}
\description{
Create a visual table from a summariseRecordCount() result.
}
\examples{
\donttest{
library(dplyr, warn.conflicts = FALSE)

cdm <- mockOmopSketch()

summarisedResult <- summariseRecordCount(
  cdm = cdm,
  omopTableName = c("condition_occurrence", "drug_exposure"),
  interval = "years",
  ageGroup = list("<=20" = c(0, 20), ">20" = c(21, Inf)),
  sex = TRUE
)

tableRecordCount(result = summarisedResult)

PatientProfiles::mockDisconnect(cdm = cdm)
}
}
