% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Backwards.R
\name{generatePresentationMultiple}
\alias{generatePresentationMultiple}
\title{generatePresentationMultiple}
\usage{
generatePresentationMultiple(
  server,
  username,
  password,
  dbms,
  resultsSchema = NULL,
  targetId = 1,
  targetName = "target cohort",
  cmSubsetId = 2,
  sccsSubsetId = NULL,
  indicationName = NULL,
  outcomeIds = 3,
  outcomeNames = "outcome cohort",
  comparatorIds = c(2, 4),
  comparatorNames = c("comparator cohort 1", "comparator cohort 2"),
  covariateIds = NULL,
  details = list(studyPeriod = "All Time", restrictions = "Age - None"),
  title = "ASSURE 001 ...",
  lead = "add name",
  date = Sys.Date(),
  backgroundText = "",
  evaluationText = "",
  outputLocation,
  outputName = paste0("presentation_", gsub(":", "_", gsub(" ", "_",
    as.character(date()))), ".html"),
  intermediateDir = tempdir()
)
}
\arguments{
\item{server}{The server containing the result database}

\item{username}{The username for an account that can access the result database}

\item{password}{The password for an account that can access the result database}

\item{dbms}{The dbms used to access the result database}

\item{resultsSchema}{The result database schema}

\item{targetId}{The cohort definition id for the target cohort}

\item{targetName}{A friendly name for the target cohort}

\item{cmSubsetId}{Optional a subset ID for the cohort method/prediction results}

\item{sccsSubsetId}{Optional a subset ID for the SCCS and characterization results}

\item{indicationName}{A name for the indication if used or NULL}

\item{outcomeIds}{The cohort definition id for the outcome}

\item{outcomeNames}{Friendly names for the outcomes}

\item{comparatorIds}{The cohort method comparator cohort id}

\item{comparatorNames}{Friendly names for the comparators}

\item{covariateIds}{A vector of covariateIds to include in the characterization}

\item{details}{a list with the studyPeriod and restrictions}

\item{title}{A title for the presentation}

\item{lead}{The name of the presentor}

\item{date}{The date of the presentation}

\item{backgroundText}{a character with any background text}

\item{evaluationText}{a list of bullet points for the evaluation}

\item{outputLocation}{The file location and name to save the protocol}

\item{outputName}{The name of the html protocol that is created}

\item{intermediateDir}{The work directory for quarto}
}
\value{
An named R list with the elements 'standard' and 'source'
}
\description{
Generates a presentation from a Strategus result
}
\details{
Specify the connection details to the result database and the schema name
to generate a presentation.
}
\seealso{
Other Reporting: 
\code{\link{generateFullReport}()},
\code{\link{generatePresentation}()}
}
\concept{Reporting}
