% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funguild.R
\name{funguild_assign}
\alias{funguild_assign}
\title{Assign Guilds to Organisms Based on Taxonomic Classification}
\usage{
funguild_assign(
  otu_table,
  db_url = NULL,
  db_funguild = NULL,
  tax_col = "Taxonomy"
)
}
\arguments{
\item{otu_table}{A \code{data.frame} with a \code{character}
column named "\code{Taxonomy}" (or another name as specified in
\code{tax_col}), as well as any other columns.
Each entry in "\code{otu_table$Taxonomy}" should be a comma-, colon-,
underscore-, or semicolon-delimited classification of an organism.
Rank indicators as given by Sintax ("\verb{k:}", "\verb{p:}"...) or Unite ("\code{k__},
"\code{p__}", ...) are also allowed.
A \code{character} vector, representing only the taxonomic classification,
is also accepted.}

\item{db_url}{a length 1 character string giving the URL to retrieve the database
from}

\item{db_funguild}{A \code{data.frame} representing the FUNGuild as returned by
\code{\link[=get_funguild_db]{get_funguild_db()}}
If not supplied, the default database will be downloaded.}

\item{tax_col}{A \code{character} string, optionally giving an alternate
column name in \code{otu_table} to use instead of \code{otu_table$Taxonomy}.}
}
\value{
A \code{\link[tibble:tibble]{tibble::tibble}} containing all columns of
\code{otu_table}, plus relevant columns of information from the FUNGuild
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-stable-green" alt="lifecycle-stable"></a>
}}


The original function and documentation was written by Brendan Furneaux
in the \href{https://github.com/brendanf/FUNGuildR/}{FUNGuildR} package.

These functions have identical behavior if supplied with a database; however
they download the database corresponding to their name by default.

Taxa present in the database are matched to the taxa present in the supplied
\code{otu_table} by exact name.
In the case of multiple matches, the lowest (most specific) rank is chosen.
No attempt is made to check or correct the classification in
\code{otu_table$Taxonomy}.
}
\references{
Nguyen NH, Song Z, Bates ST, Branco S, Tedersoo L, Menke J,
Schilling JS, Kennedy PG. 2016. \emph{FUNGuild: An open annotation tool for
parsing fungal community datasets by ecological guild}. Fungal Ecology
20:241-248.
}
\author{
Brendan Furneaux (orcid: \href{https://orcid.org/0000-0003-3522-7363}{0000-0003-3522-7363}),
modified by Adrien Taudière
}
