% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{prep_data_COVID_score}
\alias{prep_data_COVID_score}
\title{prep_data_COVID_score}
\usage{
prep_data_COVID_score(
  dat,
  featID = c("gp", "dha", "crea", "mufa", "apob_apoa1", "tyr", "ile", "sfa_fa", "glc",
    "lac", "faw6_faw3", "phe", "serum_c", "faw6_fa", "ala", "pufa", "glycine", "his",
    "pufa_fa", "val", "leu", "alb", "faw3", "ldl_c", "serum_tg"),
  quiet = FALSE
)
}
\arguments{
\item{dat}{numeric data-frame with Nightingale-metabolomics}

\item{featID}{vector of strings with the names of metabolic features included in the COVID-score}

\item{quiet}{logical to suppress the messages in the console}
}
\value{
The Nightingale-metabolomics data-frame after pre-processing (checked for zeros, z-scaled and log-transformed) according to what has been done by the authors of the original papers.
}
\description{
Helper function to pre-process the Nightingale Health metabolomics data-set before applying the COVID score.
}
\examples{
require(MiMIR)
require(matrixStats)

#load the Nightignale metabolomics dataset
metabolic_measures <- synthetic_metabolic_dataset
#Prepare the metabolic features fo the mortality score
prepped_met <- prep_data_COVID_score(dat=metabolic_measures)


}
\references{
This function is constructed to be able to follow the pre-processing steps described in:
Nightingale Health UK Biobank Initiative et al. (2021) Metabolic biomarker profiling for identification of susceptibility to severe pneumonia and COVID-19 in the general population. eLife, 10, e63033, \url{doi:10.7554/eLife.63033}
}
\seealso{
prep_met_for_scores, covid_betas, comp_covid_score
}
