% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{oilvitaminA_df}
\alias{oilvitaminA_df}
\title{Utilization of Vitamin A in Rats}
\format{
A data frame with 20 observations and 2 variables:
\describe{
  \item{type}{Factor variable indicating the oil type used to deliver vitamin A (corn or castor oil)}
  \item{avit}{Integer variable representing the measured vitamin A concentration in the liver}
}
}
\source{
Data taken from the isdals package version 3.0.1
}
\usage{
data(oilvitaminA_df)
}
\description{
This dataset, oilvitaminA_df, is a data frame containing vitamin A concentrations
in the livers of rats after being fed vitamin A dissolved in different types of oil.
Twenty rats were divided into two groups: one received vitamin A in corn oil and the other
in castor oil (American oil). After three days of feeding, vitamin A concentration in the liver
was measured on the fourth day.
}
\details{
The dataset name has been kept as 'oilvitaminA_df' to avoid confusion with other datasets
in the R ecosystem. This naming convention helps distinguish this dataset as part of the
MedxR package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been modified
in any way.
}
