% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSE_Plotting_PMs.R
\name{TradePlot}
\alias{TradePlot}
\alias{Tplot}
\alias{Tplot2}
\alias{Tplot3}
\alias{NOAA_plot2}
\title{Generic Trade-Plot Function}
\usage{
TradePlot(
  MSEobj,
  ...,
  Lims = c(0.2, 0.2, 0.8, 0.8),
  Title = NULL,
  Labels = NULL,
  Satisficed = FALSE,
  Show = "both",
  point.size = 2,
  lab.size = 4,
  axis.title.size = 12,
  axis.text.size = 10,
  legend = TRUE,
  legend.title.size = 12,
  position = c("right", "bottom"),
  cols = NULL,
  fill = "gray80",
  alpha = 0.4,
  PMlist = NULL,
  Refs = NULL,
  Yrs = NULL
)

Tplot(MSEobj, Lims = c(0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5, 0.5), ...)

Tplot2(MSEobj, Lims = c(0.2, 0.2, 0.8, 0.8), ...)

Tplot3(MSEobj, Lims = c(0.5, 0.5, 0.8, 0.5), ...)

NOAA_plot2(MSEobj)
}
\arguments{
\item{MSEobj}{An object of class \code{MSE}}

\item{...}{Names of Performance Metrics (PMs), or other arguments to \code{TradePlot}. First PM is recycled if number of PMs is not even}

\item{Lims}{A numeric vector of acceptable risk/minimum probability thresholds. Recycled if not equal to number of PMs.}

\item{Title}{Optional title for each plot. Character vector of \code{length(PMs)}/2. Recycled.}

\item{Labels}{Optional named list specifying new labels for MPs. For example: \code{Labels = list(AvC="Average Catch", CC1="Constant Catch")}}

\item{Satisficed}{Logical. Show only the MPs that meet minimum acceptable thresholds (specified in \code{Lims})}

\item{Show}{Character. Show the plots ('plots'), results table ('table'), 'both' (default), or invisibly return objects only ('none')}

\item{point.size}{Numeric. Size of the MP points}

\item{lab.size}{Numeric. Size of MP label. Set to NULL to remove MP labels.}

\item{axis.title.size}{Numeric. Size of axis titles}

\item{axis.text.size}{Numeric. Size of axis text}

\item{legend}{Logical. Include legend?}

\item{legend.title.size}{Numeric. Size of legend title text}

\item{position}{Character. Position of legend - 'right' or 'bottom'}

\item{cols}{Optional character vector of colors for the legend (MP Types) or if \code{cols} is a character vector of length \code{MSEobj@nMPs},
then the MP labels are colored (no color legend).}

\item{fill}{Character. Color of the fill}

\item{alpha}{Numeric. Transparency of fill}

\item{PMlist}{Optional list of PM names. Overrides any supplied in ... above}

\item{Refs}{An optional named list (matching the PM names) with numeric values to override the default \code{Ref} values. See examples.}

\item{Yrs}{An optional named list (matching the PM names) with numeric values to override the default \code{Yrs} values. See examples.}
}
\value{
Invisibly returns a list with summary table of MP performance and
the ggplot objects for the plots
}
\description{
Generic Trade-Plot Function
}
\section{Functions}{
\itemize{
\item \code{Tplot()}: A trade-off plot showing probabilities that:
\itemize{
\item not overfishing (PNOF) against long-term yield is > 50\\% of reference yield (LTY)
\item spawning biomass is below BMSY (P100) against LTY
\item spawning biomass is below 0.5BMSY (P50) against LTY
\item spawning biomass is below 0.1BMSY (P10) against LTY
}

\item \code{Tplot2()}: A trade-off plot showing probabilities that:
\itemize{
\item short-term yield is > 50\\% of reference yield(STY) against long-term yield is > 50\\% of reference yield (LTY)
\item spawning biomass is below 0.1BMSY (P10) against average annual variability in yield is < 20\\% (AAVY)
}

\item \code{Tplot3()}: A trade-off plot showing probabilities that:
\itemize{
\item not overfishing (PNOF) against long-term yield is > 50\\% of reference yield (LTY)
\item spawning biomass is below 0.1BMSY (P10) against average annual variability in yield is < 20\\% (AAVY)
}

\item \code{NOAA_plot2()}: A trade-off plot developed for NOAA showing probabilities that:
\itemize{
\item not overfishing (PNOF) against long-term yield is > 50\\% of reference yield (LTY)
\item spawning biomass is below 0.5BMSY (P50) against average annual variability in yield is < 15\\% (AAVY)
}

}}
\author{
A. Hordyk
}
