% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCF_to_catalog_functions.R
\name{ReadVCF}
\alias{ReadVCF}
\title{Read in the data lines of a Variant Call Format (VCF) file}
\usage{
ReadVCF(
  file,
  variant.caller = "unknown",
  name.of.VCF = NULL,
  tumor.col.name = NA,
  filter.status = DefaultFilterStatus(variant.caller),
  get.vaf.function = NULL,
  ...
)
}
\arguments{
\item{file}{The name/path of the VCF file, or a complete URL.}

\item{variant.caller}{Name of the variant caller that produces the VCF, can
be either \code{"strelka"}, \code{"mutect"}, \code{"freebayes"} or
\code{"unknown"}. This information is needed to calculate the VAFs (variant
allele frequencies). If \code{"unknown"}(default) and
\code{get.vaf.function} is NULL, then VAF and read depth will be NAs.}

\item{name.of.VCF}{Name of the VCF file. If \code{NULL}(default), this
function will remove all of the path up to and including the last path
separator (if any) in \code{file} and file path without extensions (and the
leading dot) will be used as the name of the VCF file.}

\item{tumor.col.name}{Optional. Only applicable to \strong{Mutect} VCF. Name
or index of the column in \strong{Mutect} VCF which contains the tumor
sample information. It \strong{must} have quotation marks if specifying the
column name. If \code{tumor.col.name} is equal to \code{NA}(default), this
function will use the 10th column to calculate VAFs. See
\code{\link{GetMutectVAF}} for more details.}

\item{filter.status}{The character string in column \code{FILTER} of the VCF
that indicates that a variant has passed all the variant caller's filters.
Variants (lines in the VCF) for which the value in column \code{FILTER}
does not equal \code{filter.status} are silently excluded from the output.
The internal function \code{DefaultFilterStatus} tries to infer
\code{filter.status} based on \code{variant.caller}. If
\code{variant.caller} is "unknown", user must specify \code{filter.status}
explicitly. If \code{filter.status = NULL}, all variants are retained. If
there is no \code{FILTER} column in the VCF, all variants are retained with
a warning.}

\item{get.vaf.function}{Optional. Only applicable when \code{variant.caller} is
\strong{"unknown"}. Function to calculate VAF(variant allele frequency) and read
  depth information from original VCF. See \code{\link{GetMutectVAF}} as an example.
  If \code{NULL}(default) and \code{variant.caller} is "unknown", then VAF
  and read depth will be NAs.}

\item{...}{Optional arguments to \code{get.vaf.function}.}
}
\value{
A data frame storing data lines of the VCF file with two additional
  columns added which contain the VAF(variant allele frequency) and read
  depth information.
}
\description{
Read in the data lines of a Variant Call Format (VCF) file
}
\keyword{internal}
