% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/i14y_search_catalog.R
\name{i14y_search_catalog}
\alias{i14y_search_catalog}
\title{Search the catalog for datasets, data services and public services.}
\usage{
i14y_search_catalog(
  query = NULL,
  language = "de",
  accessRights = NULL,
  formats = NULL,
  publishers = NULL,
  statuses = NULL,
  themes = NULL,
  types = NULL,
  page = NULL,
  pageSize = NULL
)
}
\arguments{
\item{query}{string. The search query}

\item{language}{string. The language to use for the search}

\item{accessRights}{vector of strings. Only results with one of the
specified access rights (PUBLIC, NON_PUBLIC, RESTRICTED) are returned}

\item{formats}{vector of strings. Only results with at least one distribution
providing one of the specified formats are returned}

\item{publishers}{vector of strings. Only results with one of the specified
publishers are returned}

\item{statuses}{vector of strings. Only results with one of the specified
registration statuses are returned}

\item{themes}{vector of strings. Only results corresponding to one of the
specified themes are returned}

\item{types}{vector of strings. Only results with one of the specified types
(Dataset, DataService, PublicService) are returned}

\item{page}{integer. The number of the result page to return}

\item{pageSize}{integer. The size of each result page}
}
\value{
a tibble
}
\description{
Search the catalog for datasets, data services and public services.
}
\examples{
i14y_search_catalog(query = "noga")
}
