% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loading_metrics.R
\name{loading_metrics}
\alias{loading_metrics}
\title{Multi-metric evaluation of factor loading matrix estimation error}
\usage{
loading_metrics(A_true, A_hat)
}
\arguments{
\item{A_true}{True loading matrix (p x m)}

\item{A_hat}{Estimated loading matrix (p x m)}
}
\value{
data.frame with MSE, RMSE, MAE, MaxDev, and Cosine similarity
}
\description{
Multi-metric evaluation of factor loading matrix estimation error
}
\examples{
## simulated example
p <- 100; m <- 5
Ag_true  <- matrix(rnorm(p*m), p, m)
Ag_hat   <- Ag_true + matrix(rnorm(p*m, 0, 0.1), p, m)
metrics  <- loading_metrics(Ag_true, Ag_hat)
print(metrics)
}
