% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.mjmcmc}
\alias{predict.mjmcmc}
\title{Predict using a mjmcmc result object.}
\usage{
\method{predict}{mjmcmc}(object, x, link = function(x) x, quantiles = c(0.025, 0.5, 0.975), ...)
}
\arguments{
\item{object}{The model to use.}

\item{x}{The new data to use for the prediction, a matrix where each row is an observation.}

\item{link}{The link function to use}

\item{quantiles}{The quantiles to calculate credible intervals for the posterior modes (in model space).}

\item{...}{Not used.}
}
\value{
A list containing aggregated predictions.
\item{mean}{Mean of aggregated predictions.}
\item{quantiles}{Quantiles of aggregated predictions.}
}
\description{
Predict using a mjmcmc result object.
}
\examples{
result <- mjmcmc(matrix(rnorm(600), 100), gaussian.loglik)
preds <- predict(result, matrix(rnorm(500), 100))

}
