% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/environment_mix_lib_package.R
\name{Comp.Mix}
\alias{Comp.Mix}
\title{A comprehensive toolkit for environmental mixtures analysis}
\usage{
Comp.Mix(
  y,
  x,
  z = NULL,
  y.type,
  test.pct = 0.5,
  var.select = NULL,
  interaction = NULL,
  interaction.exp.cov = NULL,
  covariates.forcein = NULL,
  bkmr.pip = 0.5,
  bkmr.iter = 500,
  formula = NULL,
  expnms = NULL,
  seed = 1234,
  verbose = TRUE
)
}
\arguments{
\item{y}{A vector of either continuous or binary values to indicate the health outcome}

\item{x}{A matrix of numeric values to indicate the chemical mixtures}

\item{z}{A matrix of numeric values to indicate the covariates}

\item{y.type}{A character value of either "continuous" or "binary"}

\item{test.pct}{A numeric scalar between 0 and 1 to indicate the proportion allocated as test samples}

\item{var.select}{A logical value to indicate whether to perform variable selection}

\item{interaction}{A logical value (TRUE/FALSE) to indicate whether to include
pairwise interaction terms between all the chemical mixtures x}

\item{interaction.exp.cov}{A logical value (TRUE/FALSE) to indicate whether to include
pairwise interaction terms between all the chemical mixtures x and covariates z. If interaction.exp.cov=TRUE,
interaction=TURE or interaction=FALSE will be ignored}

\item{covariates.forcein}{A logical value (TRUE/FALSE) to indicate whether to force in any covariates}

\item{bkmr.pip}{A numeric scalar between 0 and 1 to indicate the cutoff for the
posterior inclusion probability in BKMR}

\item{bkmr.iter}{A positive integer to indicate the number of MCMC iterations for bkmr}

\item{formula}{the formula for qgcomp and wqs}

\item{expnms}{a vector of characters for names of exposure variables}

\item{seed}{an integer value for seed}

\item{verbose}{a logical value to show information}
}
\value{
A list object which may contain up to 8 cases
\describe{
\item{Case 1}{variable selection on main effects for exposures and confounders}


}

Each case may contain some of the following elements
\describe{
\item{betaest}{a numeric vector of coeffcients for the exposures}
\item{z_betaest}{a numeric vector of coeffcients for the covariates}
\item{sse}{A positive scalar to indicate sum of squares error}
\item{corr}{A numeric scalar between -1 and 1 to indicate correlation coefficient}
}
}
\description{
A comprehensive toolkit for environmental mixtures analysis
}
\examples{
dat <- lmi_simul_dat(n=1000,p=20,q=5,
block_idx=c(1,1,2,2,3,1,1,1,1,1,2,2,2,2,3,3,3,3,3,3),
within_rho=0.6,btw_rho=0.1,R2=0.2,
effect_size=1,effect_size_i=1,
cancel_effect = FALSE)
#Example 1: The users would like to perform variable selections
#on main effects of exposures and covariates, and outcome, exposures and
#covariates are entered. For any individual interactions that the users would
#like to include in the models, they can add those into the covariate z.
res_ex1 <- Comp.Mix(y.type="continuous",y=dat$y, x=dat$x, z=dat$z, test.pct=0.5,
var.select = TRUE, interaction = FALSE, interaction.exp.cov = FALSE,
covariates.forcein = FALSE,
bkmr.pip=0.5, seed=2023)

}
\author{
Wei Hao <weihao@umich.edu>
}
