% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseAchillesCodeUse.R
\name{summariseAchillesCodeUse}
\alias{summariseAchillesCodeUse}
\title{Summarise code use from achilles counts.}
\usage{
summariseAchillesCodeUse(x, cdm, countBy = c("record", "person"))
}
\arguments{
\item{x}{A codelist.}

\item{cdm}{A cdm reference via CDMConnector.}

\item{countBy}{Either "record" for record-level counts or "person" for
person-level counts.}
}
\value{
A tibble with summarised counts.
}
\description{
Summarise code use from achilles counts.
}
\examples{
\donttest{
cdm <- mockVocabRef("database")
oa <- getCandidateCodes(cdm = cdm, keywords = "osteoarthritis")
result_achilles <- summariseAchillesCodeUse(list(oa = oa$concept_id), cdm = cdm)
result_achilles
CDMConnector::cdmDisconnect(cdm)
}
}
