% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCodelists.R
\name{compareCodelists}
\alias{compareCodelists}
\title{Compare overlap between two sets of codes}
\usage{
compareCodelists(codelist1, codelist2)
}
\arguments{
\item{codelist1}{Output of getCandidateCodes or a codelist}

\item{codelist2}{Output of getCandidateCodes.}
}
\value{
Tibble with information on the overlap of codes in both codelists.
}
\description{
Compare overlap between two sets of codes
}
\examples{
\donttest{
cdm <- mockVocabRef()
codes1 <- getCandidateCodes(
 cdm = cdm,
 keywords = "Arthritis",
 domains = "Condition",
 includeDescendants = TRUE
)
codes2 <- getCandidateCodes(
 cdm = cdm,
 keywords = c("knee osteoarthritis", "arthrosis"),
 domains = "Condition",
 includeDescendants = TRUE
)
compareCodelists(
 codelist1 = codes1,
 codelist2 = codes2
)
}
}
