% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitACS.R
\name{fitACS}
\alias{fitACS}
\alias{optimACS}
\title{Autocorrelation structure fit}
\usage{
fitACS(acf, ID, start = NULL, lag = NULL)

optimACS(par, id, eACS, error = "MSE")
}
\arguments{
\item{acf}{vector of autocorrelation function values from lag 0}

\item{ID}{ACS id}

\item{start}{starting parameter value}

\item{lag}{acf lag}

\item{par}{parameter value}

\item{id}{ACS id}

\item{eACS}{empirical ACS}

\item{error}{which error to minimize}
}
\description{
Autocorrelation structure fit

Auxiliary function passed to fitACS
}
\examples{

x <- AR1(1000, .8)

acsfit <- fitACS(acf(x, plot = FALSE)$acf, 'weibull', c(1, 1))

}
\keyword{internal}
