% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BT_devTweedie.R
\name{BT_devTweedie}
\alias{BT_devTweedie}
\title{Deviance function for the Tweedie family.}
\usage{
BT_devTweedie(y, mu, tweedieVal, w = NULL)
}
\arguments{
\item{y}{a vector containing the observed values.}

\item{mu}{a vector containing the fitted values.}

\item{tweedieVal}{a numeric representing the Tweedie Power. It has to be a positive number outside of the interval ]0,1[.}

\item{w}{an optional vector of weights.}
}
\value{
A vector of individual deviance contribution.
}
\description{
Compute the deviance for the Tweedie family case.
}
\details{
This function computes the Tweedie related deviance. The latter is defined as:

\deqn{d(y, mu, w) = w (y-mu)^2, if tweedieVal = 0;}
\deqn{d(y, mu, w) = 2 w (y log(y/mu) + mu - y), if tweedieVal = 1;}
\deqn{d(y, mu, w) = 2 w (log(mu/y) + y/mu - 1), if tweedieVal = 2;}
\deqn{d(y, mu, w) = 2 w (max(y,0)^(2-p)/((1-p)(2-p)) - y mu^(1-p)/(1-p) + mu^(2-p)/(2-p)), else.}
}
\references{
M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |: GLMs and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries ||: Tree-Based Methods and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2019). \strong{Effective Statistical Learning Methods for Actuaries |||: Neural Networks and Extensions}, \emph{Springer Actuarial}.

M. Denuit, D. Hainaut and J. Trufin (2022). \strong{Response versus gradient boosting trees, GLMs and neural networks under Tweedie loss and log-link}.
Accepted for publication in \emph{Scandinavian Actuarial Journal}.

M. Denuit, J. Huyghe and J. Trufin (2022). \strong{Boosting cost-complexity pruned trees on Tweedie responses: The ABT machine for insurance ratemaking}.
Paper submitted for publication.

M. Denuit, J. Trufin and T. Verdebout (2022). \strong{Boosting on the responses with Tweedie loss functions}. Paper submitted for publication.
}
\seealso{
\code{\link{BT}}, \code{\link{BT_call}}.
}
\author{
Gireg Willame \email{gireg.willame@gmail.com}

\emph{This package is inspired by the \code{gbm3} package. For more details, see \url{https://github.com/gbm-developers/gbm3/}}.
}
