% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePedigree.R
\name{buildWithinGenerations}
\alias{buildWithinGenerations}
\title{Process Generations for Pedigree Simulation}
\usage{
buildWithinGenerations(
  sizeGens,
  marR,
  sexR,
  Ngen,
  verbose = FALSE,
  personID = "ID",
  momID = "momID",
  dadID = "dadID",
  code_male = "M",
  code_female = "F"
)
}
\arguments{
\item{sizeGens}{A numeric vector containing the sizes of each generation within the pedigree.}

\item{marR}{Mating rate. A numeric value ranging from 0 to 1 which determines
the proportion of mated (fertilized) couples in the pedigree within each
generation. For instance, marR  = 0.5 suggests 50 percent of the offspring in
 a specific generation will be  mated and have their offspring.}

\item{sexR}{Sex ratio of offspring. A numeric value ranging from 0 to 1 that
determines the proportion of males in all offspring in this pedigree. For
instance, 0.4 means 40 percent of the offspring will be male.}

\item{Ngen}{Number of generations. An integer >= 2 that determines how many
generations the simulated pedigree will have. The first generation is always
a fertilized couple. The last generation has no mated individuals.}

\item{verbose}{logical  If TRUE, message progress through stages of algorithm}

\item{personID}{character.  Name of the column in ped for the person ID variable}

\item{momID}{character.  Name of the column in ped for the mother ID variable}

\item{dadID}{character.  Name of the column in ped for the father ID variable}

\item{code_male}{The value to use for males. Default is "M"}

\item{code_female}{The value to use for females. Default is "F"}
}
\value{
A data frame representing the simulated pedigree, including columns for family ID (`fam`),
}
\description{
This function iterates through generations in a pedigree simulation, assigning IDs,
creating data frames, determining sexes, and managing pairing within each generation.
}
