/*
 * Decompiled with CFR 0.152.
 */
package com.github.javacliparser;

import com.github.javacliparser.AbstractOption;
import com.github.javacliparser.SerializeUtils;
import java.io.File;

public abstract class AbstractClassOption
extends AbstractOption {
    private static final long serialVersionUID = 1L;
    public static final String FILE_PREFIX_STRING = "file:";
    public static final String INMEM_PREFIX_STRING = "inmem:";
    protected Object currentValue;
    protected Class<?> requiredType;
    protected String defaultCLIString;
    protected String nullString;

    public AbstractClassOption(String name, char cliChar, String purpose, Class<?> requiredType, String defaultCLIString) {
        this(name, cliChar, purpose, requiredType, defaultCLIString, null);
    }

    public AbstractClassOption(String name, char cliChar, String purpose, Class<?> requiredType, String defaultCLIString, String nullString) {
        super(name, cliChar, purpose);
        this.requiredType = requiredType;
        this.defaultCLIString = defaultCLIString;
        this.nullString = nullString;
        this.resetToDefault();
    }

    public void setCurrentObject(Object obj) {
        if (!(obj == null && this.nullString != null || this.requiredType.isInstance(obj) || obj instanceof String || obj instanceof File)) {
            throw new IllegalArgumentException("Object not of required type.");
        }
        this.currentValue = obj;
    }

    public Object getValue() {
        return this.currentValue;
    }

    public Class<?> getRequiredType() {
        return this.requiredType;
    }

    public String getNullString() {
        return this.nullString;
    }

    public Object materializeObject() {
        if (this.currentValue == null || this.requiredType.isInstance(this.currentValue)) {
            return this.currentValue;
        }
        if (this.currentValue instanceof File) {
            File inputFile = (File)this.currentValue;
            Object result = null;
            try {
                result = SerializeUtils.readFromFile(inputFile);
            }
            catch (Exception ex) {
                throw new RuntimeException("Problem loading " + this.requiredType.getName() + " object from file '" + inputFile.getName() + "':\n" + ex.getMessage(), ex);
            }
            return result;
        }
        throw new RuntimeException("Could not materialize object of required type " + this.requiredType.getName() + ", found " + this.currentValue.getClass().getName() + " instead.");
    }

    @Override
    public String getDefaultCLIString() {
        return this.defaultCLIString;
    }

    public static String classToCLIString(Class<?> aClass, Class<?> requiredType) {
        String packageName;
        String className = aClass.getName();
        if (className.startsWith(packageName = requiredType.getPackage().getName())) {
            className = className.substring(packageName.length() + 1, className.length());
        }
        return className;
    }

    @Override
    public abstract String getValueAsCLIString();

    @Override
    public abstract void setValueViaCLIString(String var1);

    public static String stripPackagePrefix(String className, Class<?> expectedType) {
        if (className.startsWith(expectedType.getPackage().getName())) {
            return className.substring(expectedType.getPackage().getName().length() + 1);
        }
        return className;
    }
}

