/*
 * Decompiled with CFR 0.152.
 */
package dmLab.discretizer.fayyadIrani;

import dmLab.discretizer.DiscretizerParams;
import dmLab.discretizer.change.CutPoints;
import dmLab.discretizer.change.DiscChange;
import dmLab.discretizer.change.Event;
import dmLab.utils.ArrayUtils;
import dmLab.utils.MathUtils;
import java.util.ArrayList;
import weka.core.Utils;

public final class FayyadIrani
extends DiscChange {
    /*
     * WARNING - void declaration
     */
    @Override
    public final float[] findRanges(float[] values, float[] decision, DiscretizerParams discParams) {
        void var2_2;
        Event[] eventArray = FayyadIrani.getEvents(values, decision);
        decision = eventArray;
        CutPoints cPoints = FayyadIrani.calcCutPoints(eventArray);
        this.ranges = this.selectBestCutPoint(cPoints, 0, var2_2.size());
        if (this.ranges != null) {
            void var1_1;
            this.ranges.add(Float.valueOf(MathUtils.maxValue((float[])var1_1)));
        }
        return this.getRanges();
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<Float> selectBestCutPoint(CutPoints cPoints, int begin, int end) {
        double[] bestLeftSet = null;
        double[] bestRightSet = null;
        int bestCutPointIndex = -1;
        if (end - begin < 2) {
            return null;
        }
        ArrayList<Float> cutPointsList = new ArrayList<Float>();
        double[] priorSet = cPoints.getClassesSum(begin, end);
        double priorEntropy = MathUtils.entropy(priorSet, false);
        double priorEventsNumber = MathUtils.sum(priorSet);
        double priorClassesNumber = priorSet.length - ArrayUtils.count(priorSet, 0.0);
        double bestEntropy = priorEntropy;
        int end_1 = end - 1;
        for (int i = begin; i < end_1; ++i) {
            double d;
            double[] leftSet = cPoints.getClassesSum(begin, i + 1);
            double[] rightSet = cPoints.getClassesSum(i + 1, end);
            double leftSize = MathUtils.sum(leftSet);
            double rightSize = MathUtils.sum(rightSet);
            double currentEntropy = leftSize / priorEventsNumber * MathUtils.entropy(leftSet, false) + rightSize / priorEventsNumber * MathUtils.entropy(rightSet, false);
            if (!(d < bestEntropy)) continue;
            bestEntropy = currentEntropy;
            bestCutPointIndex = i;
            bestLeftSet = leftSet;
            bestRightSet = rightSet;
        }
        double priorCutPointsNumber = cPoints.getCutsSum(begin, end);
        if (FayyadIrani.testCutPoint(priorEntropy, priorClassesNumber, priorCutPointsNumber, priorEventsNumber, bestEntropy, bestLeftSet, bestRightSet)) {
            void var3_3;
            void var1_1;
            void var2_2;
            cutPointsList.add(Float.valueOf(cPoints.getValue(bestCutPointIndex)));
            this.selectBestCutPoint(cPoints, (int)var2_2, bestCutPointIndex + 1);
            this.selectBestCutPoint((CutPoints)var1_1, bestCutPointIndex + 1, (int)var3_3);
        }
        return cutPointsList;
    }

    /*
     * WARNING - void declaration
     */
    private static boolean testCutPoint(double priorEntropy, double priorClassesNumber, double priorCutPointsNumber, double priorEventsNumber, double bestEntropy, double[] leftSet, double[] rightSet) {
        double d;
        void var2_1;
        double d2;
        double gain = priorEntropy - bestEntropy;
        if (d2 <= 0.0) {
            return false;
        }
        double entropyLeft = MathUtils.entropy(leftSet, true);
        double entropyRight = MathUtils.entropy(rightSet, false);
        double numClassesLeft = leftSet.length - ArrayUtils.count(leftSet, 0.0);
        double numClassesRight = rightSet.length - ArrayUtils.count(rightSet, 0.0);
        double delta = MathUtils.log2(Math.pow(3.0, priorClassesNumber) - 2.0) - (var2_1 * d - numClassesRight * entropyRight - numClassesLeft * entropyLeft);
        double weight = (Utils.log2((double)priorCutPointsNumber) + delta) / priorEventsNumber;
        return gain > weight;
    }
}

