/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.core.math.functions.IParametersDomain;
import jdplus.toolkit.base.core.math.functions.IParametricMapping;
import jdplus.toolkit.base.core.ssf.likelihood.MarginalLikelihood;
import jdplus.toolkit.base.core.ssf.likelihood.MarginalLikelihoodFunctionPoint;
import jdplus.toolkit.base.core.ssf.univariate.ISsf;
import jdplus.toolkit.base.core.ssf.univariate.ISsfBuilder;
import jdplus.toolkit.base.core.ssf.univariate.ISsfData;
import jdplus.toolkit.base.core.stats.likelihood.LikelihoodFunction;

public class MarginalLikelihoodFunction<S, F extends ISsf>
implements LikelihoodFunction<MarginalLikelihood> {
    private final IParametricMapping<S> mapping;
    private final ISsfBuilder<S, F> builder;
    private final ISsfData data;
    private final boolean missing;
    private final boolean ml;
    private final boolean log;
    private final boolean mt;
    private final boolean sym;
    private final boolean scaling;
    private final boolean res;

    public static <S, F extends ISsf> Builder builder(ISsfData data, IParametricMapping<S> mapping, ISsfBuilder<S, F> builder) {
        return new Builder<S, F>(data, mapping, builder);
    }

    private MarginalLikelihoodFunction(ISsfData data, IParametricMapping<S> mapper, ISsfBuilder<S, F> builder, boolean ml, boolean log, boolean mt, boolean sym, boolean scaling, boolean res) {
        this.data = data;
        this.mapping = mapper;
        this.builder = builder;
        this.missing = data.hasMissingValues();
        this.ml = ml;
        this.log = log;
        this.mt = mt;
        this.sym = sym;
        this.scaling = scaling;
        this.res = res;
    }

    public IParametricMapping<S> getMapping() {
        return this.mapping;
    }

    public boolean isMaximumLikelihood() {
        return this.ml;
    }

    public boolean isLog() {
        return this.log;
    }

    public boolean isScalingFactor() {
        return this.scaling;
    }

    public boolean isResiduals() {
        return this.res;
    }

    @Override
    public MarginalLikelihoodFunctionPoint<S, F> evaluate(DoubleSeq parameters) {
        return new MarginalLikelihoodFunctionPoint(this, parameters);
    }

    @Override
    public IParametersDomain getDomain() {
        return this.mapping;
    }

    @Override
    public MarginalLikelihoodFunctionPoint<S, F> ssqEvaluate(DoubleSeq parameters) {
        return new MarginalLikelihoodFunctionPoint(this, parameters);
    }

    public ISsfBuilder<S, F> getBuilder() {
        return this.builder;
    }

    public ISsfData getData() {
        return this.data;
    }

    public boolean isMissing() {
        return this.missing;
    }

    public boolean isMl() {
        return this.ml;
    }

    public boolean isMultiThreaded() {
        return this.mt;
    }

    public boolean isSymmetric() {
        return this.sym;
    }

    public static class Builder<S, F extends ISsf> {
        private final IParametricMapping<S> mapping;
        private final ISsfBuilder<S, F> builder;
        private final ISsfData data;
        private boolean ml = true;
        private boolean log = false;
        private boolean mt = false;
        private boolean sym = false;
        private boolean scalingFactor = true;
        private boolean res = false;

        private Builder(ISsfData data, IParametricMapping<S> mapping, ISsfBuilder<S, F> builder) {
            this.data = data;
            this.builder = builder;
            this.mapping = mapping;
        }

        public Builder useParallelProcessing(boolean mt) {
            this.mt = mt;
            return this;
        }

        public Builder useMaximumLikelihood(boolean ml) {
            this.ml = ml;
            return this;
        }

        public Builder useLog(boolean log) {
            this.log = log;
            return this;
        }

        public Builder useSymmetricNumericalDerivatives(boolean sym) {
            this.sym = sym;
            return this;
        }

        public Builder useScalingFactor(boolean scalingFactor) {
            this.scalingFactor = scalingFactor;
            if (!scalingFactor) {
                this.log = true;
            }
            return this;
        }

        public Builder residuals(boolean res) {
            this.res = res;
            return this;
        }

        public MarginalLikelihoodFunction<S, F> build() {
            return new MarginalLikelihoodFunction<S, F>(this.data, this.mapping, this.builder, this.ml, this.log, this.mt, this.sym, this.scalingFactor, this.res);
        }
    }
}

