/*
 * Decompiled with CFR 0.152.
 */
package jdplus.toolkit.base.core.ssf.likelihood;

import jdplus.toolkit.base.api.data.DoubleSeq;
import jdplus.toolkit.base.api.math.Constants;
import jdplus.toolkit.base.core.ssf.likelihood.DiffuseLikelihood;
import jdplus.toolkit.base.core.stats.likelihood.Likelihood;

public class MarginalLikelihood
implements Likelihood {
    private final double ll;
    private final double ssqerr;
    private final double ldet;
    private final double dcorr;
    private final double mcorr;
    private final double[] res;
    private final int nobs;
    private final int nd;
    private final boolean legacy;
    private final boolean scalingFactor;

    public static Builder builder(int n, int nd) {
        return new Builder(n, nd);
    }

    private MarginalLikelihood(boolean concentrated, int n, int nd, double ssqerr, double ldet, double dcorr, double mcorr, double[] res, boolean legacy) {
        int m;
        this.scalingFactor = concentrated;
        this.nobs = n;
        this.nd = nd;
        this.ssqerr = ssqerr;
        this.ldet = ldet;
        this.dcorr = dcorr;
        this.mcorr = mcorr;
        this.res = res;
        this.legacy = legacy;
        int n2 = m = legacy ? this.nobs : this.nobs - nd;
        this.ll = m > 0 ? (this.scalingFactor ? -0.5 * ((double)m * Constants.LOGTWOPI + (double)m * (1.0 + Math.log(ssqerr / (double)m)) + ldet + dcorr - mcorr) : -0.5 * ((double)m * Constants.LOGTWOPI + ssqerr + ldet + dcorr - mcorr)) : Double.NaN;
    }

    public static MarginalLikelihood of(DiffuseLikelihood dl, double mcorr) {
        DoubleSeq e = dl.e();
        return new MarginalLikelihood(dl.isScalingFactor(), dl.dim(), dl.getD(), dl.ssq(), dl.logDeterminant(), dl.getDiffuseCorrection(), mcorr, e == null ? null : e.toArray(), dl.isLegacy());
    }

    private int m() {
        return this.legacy ? this.nobs : this.nobs - this.nd;
    }

    public boolean isLegacy() {
        return this.legacy;
    }

    public MarginalLikelihood setLegacy(boolean legacy) {
        if (this.legacy == legacy) {
            return this;
        }
        return new MarginalLikelihood(this.scalingFactor, this.nobs, this.nd, this.ssqerr, this.ldet, this.dcorr, this.mcorr, this.res, legacy);
    }

    public int getD() {
        return this.nd;
    }

    @Override
    public double factor() {
        return Math.exp((this.ldet + this.dcorr - this.mcorr) / (double)this.m());
    }

    @Override
    public double logLikelihood() {
        return this.ll;
    }

    @Override
    public int dim() {
        return this.nobs;
    }

    @Override
    public double logDeterminant() {
        return this.ldet;
    }

    @Override
    public double ser() {
        return Math.sqrt(this.ssqerr / (double)this.m());
    }

    @Override
    public double sigma2() {
        return this.ssqerr / (double)this.m();
    }

    @Override
    public double ssq() {
        return this.ssqerr;
    }

    public MarginalLikelihood rescale(double factor) {
        if (factor == 1.0) {
            return this;
        }
        double[] nres = null;
        if (this.res != null) {
            nres = new double[this.res.length];
            for (int i = 0; i < this.res.length; ++i) {
                nres[i] = Double.isFinite(this.res[i]) ? this.res[i] / factor : Double.NaN;
            }
        }
        return new MarginalLikelihood(this.scalingFactor, this.nobs, this.nd, this.ssqerr / (factor * factor), this.ldet, this.dcorr, this.mcorr, nres, this.legacy);
    }

    public double getDiffuseCorrection() {
        return this.dcorr;
    }

    public double getMarginalCorrection() {
        return this.mcorr;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ll=").append(this.logLikelihood()).append(System.lineSeparator());
        builder.append("n=").append(this.dim()).append(System.lineSeparator());
        builder.append("ssq=").append(this.ssq()).append(System.lineSeparator());
        builder.append("ldet=").append(this.logDeterminant()).append(System.lineSeparator());
        builder.append("dcorr=").append(this.getDiffuseCorrection()).append(System.lineSeparator());
        builder.append("mcorr=").append(this.getMarginalCorrection()).append(System.lineSeparator());
        return builder.toString();
    }

    @Override
    public DoubleSeq e() {
        return this.res == null ? null : DoubleSeq.of((double[])this.res);
    }

    public MarginalLikelihood add(Likelihood ll) {
        return MarginalLikelihood.builder(this.nobs + ll.dim(), this.nd).ssqErr(this.ssqerr + ll.ssq()).logDeterminant(this.ldet + ll.logDeterminant()).diffuseCorrection(this.dcorr).marginalCorrection(this.mcorr).legacy(this.legacy).concentratedScalingFactor(this.scalingFactor).build();
    }

    public static class Builder {
        private final int n;
        private final int nd;
        private double ssqerr;
        private double ldet;
        private double dcorr;
        private double mcorr;
        private double[] res;
        private boolean legacy;
        private boolean concentratedScalingFactor = true;

        Builder(int n, int nd) {
            this.n = n;
            this.nd = nd;
        }

        public Builder residuals(DoubleSeq residuals) {
            if (residuals == null) {
                return this;
            }
            if (this.ssqerr == 0.0) {
                this.ssqerr = residuals.ssq();
            }
            this.res = residuals.toArray();
            return this;
        }

        public Builder logDeterminant(double ldet) {
            this.ldet = ldet;
            return this;
        }

        public Builder diffuseCorrection(double dcorr) {
            this.dcorr = dcorr;
            return this;
        }

        public Builder marginalCorrection(double mcorr) {
            this.mcorr = mcorr;
            return this;
        }

        public Builder ssqErr(double ssq) {
            this.ssqerr = ssq;
            return this;
        }

        public Builder legacy(boolean legacy) {
            this.legacy = legacy;
            return this;
        }

        public Builder concentratedScalingFactor(boolean concentrated) {
            this.concentratedScalingFactor = concentrated;
            return this;
        }

        public MarginalLikelihood build() {
            if (this.nd == 0 && this.dcorr != 0.0) {
                throw new IllegalArgumentException("Incorrect diffuse initialisation");
            }
            return new MarginalLikelihood(this.concentratedScalingFactor, this.n, this.nd, this.ssqerr, this.ldet, this.dcorr, this.mcorr, this.res, this.legacy);
        }
    }
}

