/*
 * Decompiled with CFR 0.152.
 */
package com.qarks.util.fetch.logic;

import com.qarks.util.fetch.logic.DynamicDataSet;
import com.qarks.util.fetch.logic.DynamicTableDataProvider;
import java.io.Serializable;
import java.util.Vector;

public class DynamicDataFetcher {
    private DynamicTableDataProvider dataProvider;
    private FetcherWorkerThread workerThread = null;
    private Vector<DynamicDataSet> pendingDataFetched = new Vector();

    public DynamicDataFetcher(DynamicTableDataProvider dynamicTableDataProvider) {
        this.dataProvider = dynamicTableDataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asynchFetchData(Object object, String string, boolean bl, int n, int n2) {
        WaitingFetch waitingFetch = new WaitingFetch(object, string, bl, n, n2);
        DynamicDataFetcher dynamicDataFetcher = this;
        synchronized (dynamicDataFetcher) {
            if (this.workerThread == null) {
                this.workerThread = new FetcherWorkerThread();
                this.workerThread.start();
            }
        }
        this.workerThread.addWaitingFetch(waitingFetch);
    }

    public DynamicDataSet[] consumeFetchedDataSet() {
        int n = this.pendingDataFetched.size();
        DynamicDataSet[] dynamicDataSetArray = new DynamicDataSet[n];
        for (int i = 0; i < dynamicDataSetArray.length; ++i) {
            dynamicDataSetArray[i] = this.pendingDataFetched.remove(0);
        }
        return dynamicDataSetArray;
    }

    private class WaitingFetch {
        private int offset;
        private int count;
        private boolean ascending;
        private String sortCriteria;
        private Object fetchCriteria;

        public WaitingFetch(Object object, String string, boolean bl, int n, int n2) {
            this.offset = n;
            this.count = n2;
            this.ascending = bl;
            this.sortCriteria = string;
            this.fetchCriteria = object;
        }
    }

    private class FetcherWorkerThread
    extends Thread {
        private Vector<WaitingFetch> waitingFetches = new Vector();
        private boolean stop = false;

        private FetcherWorkerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addWaitingFetch(WaitingFetch waitingFetch) {
            Vector<WaitingFetch> vector = this.waitingFetches;
            synchronized (vector) {
                this.waitingFetches.removeAllElements();
                this.waitingFetches.add(waitingFetch);
                this.waitingFetches.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.stop) {
                WaitingFetch waitingFetch = null;
                Serializable serializable = this.waitingFetches;
                synchronized (serializable) {
                    try {
                        while (this.waitingFetches.isEmpty()) {
                            this.waitingFetches.wait();
                        }
                        if (!this.waitingFetches.isEmpty()) {
                            waitingFetch = this.waitingFetches.remove(0);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                if (waitingFetch == null) continue;
                serializable = DynamicDataFetcher.this.dataProvider.fetchData(waitingFetch.fetchCriteria, waitingFetch.sortCriteria, waitingFetch.ascending, waitingFetch.offset, waitingFetch.count);
                DynamicDataFetcher.this.pendingDataFetched.add(serializable);
            }
            System.out.println("exiting fetch thread");
        }
    }
}

